/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.VariableDefinition;

public class GraphQLQueryVisitor {
    void visit(Node node) {
        if (node instanceof Document) {
            this.visitDocument((Document)node);
        } else if (node instanceof OperationDefinition) {
            this.visitOperationDefinition((OperationDefinition)node);
        } else if (node instanceof FragmentDefinition) {
            this.visitFragmentDefinition((FragmentDefinition)node);
        } else if (node instanceof VariableDefinition) {
            this.visitVariableDefinition((VariableDefinition)node);
        } else if (node instanceof SelectionSet) {
            this.visitSelectionSet((SelectionSet)node);
        } else if (node instanceof Field) {
            this.visitField((Field)node);
        } else if (node instanceof InlineFragment) {
            this.visitInlineFragment((InlineFragment)node);
        } else if (node instanceof FragmentSpread) {
            this.visitFragmentSpread((FragmentSpread)node);
        } else if (node != null) {
            throw new RuntimeException("Unknown type of node " + node + " at: " + node.getSourceLocation());
        }
    }

    protected void visitDocument(Document node) {
        for (Definition definition : node.getDefinitions()) {
            this.visit((Node)definition);
        }
    }

    protected void visitOperationDefinition(OperationDefinition node) {
        for (VariableDefinition variable : node.getVariableDefinitions()) {
            this.visitVariableDefinition(variable);
        }
        this.visitSelectionSet(node.getSelectionSet());
    }

    protected void visitFragmentDefinition(FragmentDefinition node) {
        this.visitSelectionSet(node.getSelectionSet());
        for (Directive directive : node.getDirectives()) {
            this.visit((Node)directive);
        }
    }

    protected void visitVariableDefinition(VariableDefinition node) {
    }

    protected void visitSelectionSet(SelectionSet node) {
        if (node == null) {
            return;
        }
        for (Node child : node.getChildren()) {
            this.visit(child);
        }
    }

    protected void visitField(Field node) {
        this.visitSelectionSet(node.getSelectionSet());
    }

    protected void visitInlineFragment(InlineFragment node) {
        this.visitSelectionSet(node.getSelectionSet());
    }

    protected void visitFragmentSpread(FragmentSpread node) {
        for (Directive directive : node.getDirectives()) {
            this.visit((Node)directive);
        }
    }
}

