/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.source.RemoteRetriever;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionInput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class HttpRemoteRetriever<C>
implements RemoteRetriever<C> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final URL remoteUrl;

    public HttpRemoteRetriever(URL remoteUrl) {
        this.remoteUrl = Objects.requireNonNull(remoteUrl);
    }

    @Override
    public CompletableFuture<Map<String, Object>> queryIntrospectionSchema() {
        return CompletableFuture.completedFuture(this.queryForJson(out -> {
            try {
                out.write("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\n  fragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n        }\n      }\n    }\n  }\n".getBytes(Charset.forName("UTF-8")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    public CompletableFuture<Map<String, Object>> query(ExecutionInput executionInput, C context) {
        return CompletableFuture.completedFuture(this.queryForJson(out -> {
            try {
                this.mapper.writeValue(out, (Object)executionInput);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> queryForJson(Consumer<OutputStream> bodyWriter) {
        URLConnection urlConnection = this.remoteUrl.openConnection();
        if (!(urlConnection instanceof HttpURLConnection)) {
            throw new RuntimeException("Expected an HTTP endpoint");
        }
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        try {
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("content-type", "application/json");
            bodyWriter.accept(connection.getOutputStream());
            if (connection.getResponseCode() != 200) {
                throw new IOException("Failed with HTTP error code: " + connection.getResponseCode());
            }
            Map map = (Map)this.mapper.readerFor(Map.class).readValue(connection.getInputStream());
            connection.disconnect();
            return map;
        }
        catch (Throwable throwable) {
            try {
                connection.disconnect();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

