/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.DocumentCloners;
import com.atlassian.braid.GraphQLQueryPrinter;
import com.atlassian.braid.GraphQLQueryVisitor;
import com.atlassian.braid.Link;
import com.atlassian.braid.RelativeGraphQLError;
import com.atlassian.braid.SchemaSource;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;

class QueryExecutor {
    QueryExecutor() {
    }

    <C> BatchLoader<DataFetchingEnvironment, Object> asBatchLoader(SchemaSource<C> schemaSource, Link link) {
        return environments -> this.query(schemaSource, environments, link);
    }

    <C> CompletableFuture<List<Object>> query(SchemaSource<C> schemaSource, List<DataFetchingEnvironment> environments, Link link) {
        Document doc = new Document();
        OperationDefinition queryOp = new OperationDefinition("", OperationDefinition.Operation.QUERY, new SelectionSet());
        doc.getDefinitions().add(queryOp);
        int counter = 0;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        HashMap<DataFetchingEnvironment, Field> clonedFields = new HashMap<DataFetchingEnvironment, Field>();
        for (DataFetchingEnvironment environment : environments) {
            Field original = this.findFieldWithName(environment);
            Field field = DocumentCloners.clone(original);
            field.setAlias(field.getName() + ++counter);
            clonedFields.put(environment, field);
            this.trimFieldSelection(schemaSource, environment, field);
            variables.putAll(this.collectVariables(environment, field, link, counter));
            this.processForOperations(environment, queryOp, field, link, counter);
            List<Definition> fragmentDefinitions = this.processForFragments(environment, field);
            doc.getDefinitions().addAll(fragmentDefinitions);
        }
        GraphQLQueryPrinter printer = new GraphQLQueryPrinter();
        String query = printer.print((Node)doc);
        ExecutionInput input = ExecutionInput.newExecutionInput().query(query).operationName("Batch").variables(variables).build();
        return schemaSource.query(input, environments.get(0).getContext()).thenApply(result -> {
            ArrayList<DataFetcherResult> queryResults = new ArrayList<DataFetcherResult>();
            Map data = (Map)result.getData();
            for (DataFetchingEnvironment environment : environments) {
                Field field = (Field)clonedFields.get(environment);
                Object fieldData = data.getOrDefault(field.getAlias(), null);
                queryResults.add(new DataFetcherResult(fieldData, result.getErrors().stream().filter(e -> e.getPath() == null || e.getPath().isEmpty() || field.getAlias().equals(e.getPath().get(0))).map(RelativeGraphQLError::new).collect(Collectors.toList())));
            }
            return queryResults;
        });
    }

    private Field findFieldWithName(DataFetchingEnvironment environment) {
        return environment.getFields().stream().filter(f -> environment.getFieldDefinition().getName().equals(f.getName())).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    <C> void trimFieldSelection(final SchemaSource<C> schemaSource, final DataFetchingEnvironment environment, final Field field) {
        new GraphQLQueryVisitor(){
            GraphQLOutputType parentType = null;
            GraphQLOutputType lastFieldType = null;

            @Override
            protected void visitField(Field node) {
                GraphQLOutputType type;
                if (node == field) {
                    type = environment.getFieldType();
                } else {
                    QueryExecutor.this.getLink(schemaSource.getLinks(), this.parentType.getName(), node.getName()).ifPresent(l -> node.setSelectionSet(null));
                    type = ((GraphQLObjectType)this.parentType).getFieldDefinition(node.getName()).getType();
                }
                while (type instanceof GraphQLModifiedType) {
                    type = ((GraphQLModifiedType)type).getWrappedType();
                }
                this.lastFieldType = type;
                super.visitField(node);
            }

            @Override
            protected void visitSelectionSet(SelectionSet node) {
                if (node == null) {
                    return;
                }
                if (!node.getChildren().isEmpty()) {
                    GraphQLOutputType lastParentType = this.parentType;
                    this.parentType = this.lastFieldType;
                    for (Node child : node.getChildren()) {
                        this.visit(child);
                    }
                    this.parentType = lastParentType;
                }
            }
        }.visit((Node)field);
    }

    private Map<String, Object> collectVariables(DataFetchingEnvironment environment, Field field, Link link, int counter) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (link != null) {
            Object source = environment.getSource();
            while (!(source instanceof Map)) {
                if (source instanceof CompletableFuture) {
                    try {
                        source = ((CompletableFuture)source).get();
                        continue;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (source instanceof DataFetcherResult) {
                    source = ((DataFetcherResult)source).getData();
                    continue;
                }
                throw new IllegalArgumentException("Unexpected parent type");
            }
            variables.put(link.getArgumentName() + 1, ((Map)source).get(field.getName()));
        } else if (!field.getArguments().isEmpty()) {
            for (Argument arg : this.referenceArguments(field)) {
                variables.put(arg.getName() + 1, environment.getArgument(arg.getName()));
            }
        }
        List renamedArguments = field.getArguments().stream().map(a -> {
            Value value = a.getValue();
            if (value instanceof VariableReference) {
                value = new VariableReference(((VariableReference)value).getName() + counter);
            }
            return new Argument(a.getName(), value);
        }).collect(Collectors.toList());
        field.setArguments(renamedArguments);
        return Collections.unmodifiableMap(variables);
    }

    private List<Argument> referenceArguments(Field field) {
        return field.getArguments().stream().filter(a -> a.getValue() instanceof VariableReference).collect(Collectors.toList());
    }

    private void processForOperations(DataFetchingEnvironment environment, OperationDefinition query, Field field, Link link, int counter) {
        List<VariableDefinition> variableTypes = new ArrayList<VariableDefinition>();
        if (link != null) {
            field.setArguments(Collections.singletonList(new Argument(link.getArgumentName(), (Value)new VariableReference(link.getArgumentName() + counter))));
            variableTypes = Collections.singletonList(new VariableDefinition(link.getArgumentName() + counter, (Type)new TypeName("String")));
            field.setName(link.getTargetField());
        } else if (!field.getArguments().isEmpty()) {
            List inputValueDefinitions = environment.getFieldTypeInfo().getFieldDefinition().getDefinition().getInputValueDefinitions();
            for (Argument arg : this.referenceArguments(field)) {
                variableTypes.add(new VariableDefinition(arg.getName() + counter, this.findArgumentVariableType(inputValueDefinitions, arg.getName())));
            }
        }
        query.getVariableDefinitions().addAll(variableTypes);
        query.getSelectionSet().getSelections().add(field);
    }

    private List<Definition> processForFragments(final DataFetchingEnvironment environment, Field field) {
        final ArrayList<Definition> result = new ArrayList<Definition>();
        new GraphQLQueryVisitor(){

            @Override
            protected void visitFragmentSpread(FragmentSpread node) {
                FragmentDefinition fragmentDefinition = (FragmentDefinition)environment.getFragmentsByName().get(node.getName());
                result.add(fragmentDefinition);
                super.visitFragmentSpread(node);
            }
        }.visit((Node)field);
        return result;
    }

    private Type findArgumentVariableType(List<InputValueDefinition> inputValueDefinitions, String argName) {
        return inputValueDefinitions.stream().filter(d -> d.getName().equals(argName)).findFirst().orElseThrow(IllegalStateException::new).getType();
    }

    private Optional<Link> getLink(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName) && l.getSourceField().equals(fieldName)).findFirst();
    }
}

