/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.BatchLoaderEnvironment;
import com.atlassian.braid.FieldRename;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.transformation.BraidSchemaSource;
import com.atlassian.braid.transformation.BraidingContext;
import com.atlassian.braid.transformation.DataFetcherUtils;
import com.atlassian.braid.transformation.SchemaTransformation;
import com.atlassian.braid.transformation.TopLevelFieldTransformation;
import graphql.execution.DataFetcherResult;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoader;

public class TopLevelSchemaTransformation
implements SchemaTransformation {
    @Override
    public Map<String, BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>>> transform(BraidingContext braidingContext) {
        Map<SchemaNamespace, BraidSchemaSource> dataSources = braidingContext.getDataSources();
        List<FieldDataLoaderRegistration> queryLoaders = TopLevelSchemaTransformation.addSchemaSourcesTopLevelFieldsToOperation(dataSources, braidingContext.getQueryObjectTypeDefinition(), BraidSchemaSource::getQueryType, BraidSchemaSource::getQueryFieldRenames, braidingContext.getBatchLoaderEnvironment());
        List<FieldDataLoaderRegistration> mutationLoaders = TopLevelSchemaTransformation.addSchemaSourcesTopLevelFieldsToOperation(dataSources, braidingContext.getMutationObjectTypeDefinition(), BraidSchemaSource::getMutationType, BraidSchemaSource::getMutationFieldRenames, braidingContext.getBatchLoaderEnvironment());
        return Stream.concat(queryLoaders.stream(), mutationLoaders.stream()).peek(reg -> TopLevelSchemaTransformation.registerDataFetcher(braidingContext, ((FieldDataLoaderRegistration)reg).type, ((FieldDataLoaderRegistration)reg).field)).collect(Collectors.toMap(reg -> DataFetcherUtils.getDataLoaderKey(((FieldDataLoaderRegistration)reg).type, ((FieldDataLoaderRegistration)reg).field), reg -> ((FieldDataLoaderRegistration)reg).loader));
    }

    private static void registerDataFetcher(BraidingContext context, String type, String field) {
        TopLevelDataFetcher dataFetcher = new TopLevelDataFetcher(type, field);
        context.registerDataFetcher(type, field, dataFetcher);
    }

    private static List<FieldDataLoaderRegistration> addSchemaSourcesTopLevelFieldsToOperation(Map<SchemaNamespace, BraidSchemaSource> dataSources, ObjectTypeDefinition braidOperationType, Function<BraidSchemaSource, Optional<ObjectTypeDefinition>> findOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldRename>> getFieldRename, BatchLoaderEnvironment batchLoaderEnvironment) {
        return dataSources.values().stream().map(source -> TopLevelSchemaTransformation.addSchemaSourceTopLevelFieldsToOperation(source, braidOperationType, findOperationType, getFieldRename, batchLoaderEnvironment)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<FieldDataLoaderRegistration> addSchemaSourceTopLevelFieldsToOperation(BraidSchemaSource source, ObjectTypeDefinition braidOperationType, Function<BraidSchemaSource, Optional<ObjectTypeDefinition>> findOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldRename>> getFieldRename, BatchLoaderEnvironment batchLoaderEnvironment) {
        return findOperationType.apply(source).map(operationType -> TopLevelSchemaTransformation.addSchemaSourceTopLevelFieldsToOperation(source, braidOperationType, operationType, getFieldRename, batchLoaderEnvironment)).orElse(Collections.emptyList());
    }

    private static List<FieldDataLoaderRegistration> addSchemaSourceTopLevelFieldsToOperation(BraidSchemaSource schemaSource, ObjectTypeDefinition braidOperationType, ObjectTypeDefinition sourceOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldRename>> getFieldRename, BatchLoaderEnvironment batchLoaderEnvironment) {
        List<RenamedFieldDefinition> fieldDefinitions = TopLevelSchemaTransformation.renamedFieldDefinitions(schemaSource, sourceOperationType, getFieldRename);
        List braidOperationTypeFieldDefinitions = braidOperationType.getFieldDefinitions();
        fieldDefinitions.forEach(bfd -> braidOperationTypeFieldDefinitions.add(((RenamedFieldDefinition)bfd).definition));
        return TopLevelSchemaTransformation.wireOperationFields(braidOperationType.getName(), schemaSource, fieldDefinitions, batchLoaderEnvironment);
    }

    private static List<RenamedFieldDefinition> renamedFieldDefinitions(BraidSchemaSource schemaSource, ObjectTypeDefinition sourceOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldRename>> getFieldRename) {
        return sourceOperationType.getFieldDefinitions().stream().map(definition -> {
            Optional optionalFieldRename = (Optional)getFieldRename.apply(schemaSource, definition.getName());
            return optionalFieldRename.map(fieldRename -> new RenamedFieldDefinition((FieldRename)fieldRename, (FieldDefinition)definition)).orElseGet(() -> new RenamedFieldDefinition(FieldRename.from(definition.getName(), definition.getName()), (FieldDefinition)definition));
        }).map(def -> TopLevelSchemaTransformation.renamedFieldDefinition(schemaSource, def)).collect(Collectors.toList());
    }

    private static RenamedFieldDefinition renamedFieldDefinition(BraidSchemaSource schemaSource, RenamedFieldDefinition renamedFieldDefinition) {
        FieldDefinition definition = renamedFieldDefinition.definition;
        Type renamedType = schemaSource.renameTypeToBraidName(definition.getType());
        return new RenamedFieldDefinition(renamedFieldDefinition.fieldRename, FieldDefinition.newFieldDefinition().name(renamedFieldDefinition.fieldRename.getBraidName()).type(renamedType).inputValueDefinitions(schemaSource.renameInputValueDefinitionsToBraidTypes(definition.getInputValueDefinitions())).directives(definition.getDirectives()).build());
    }

    private static List<FieldDataLoaderRegistration> wireOperationFields(String typeName, BraidSchemaSource schemaSource, List<RenamedFieldDefinition> fieldDefinitions, BatchLoaderEnvironment batchLoaderEnvironment) {
        return fieldDefinitions.stream().map(queryField -> TopLevelSchemaTransformation.wireOperationField(typeName, schemaSource, queryField, batchLoaderEnvironment)).collect(Collectors.toList());
    }

    private static FieldDataLoaderRegistration wireOperationField(String typeName, BraidSchemaSource schemaSource, RenamedFieldDefinition operationField, BatchLoaderEnvironment batchLoaderEnvironment) {
        String sourceType = schemaSource.getSourceTypeName(TypeUtils.unwrap(operationField.definition.getType()));
        TopLevelFieldTransformation fieldTransformation = new TopLevelFieldTransformation(operationField.fieldRename, schemaSource.getExtensions(sourceType));
        BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> batchLoader = schemaSource.getSchemaSource().newBatchLoader(schemaSource.getSchemaSource(), fieldTransformation, batchLoaderEnvironment);
        return new FieldDataLoaderRegistration(typeName, operationField.fieldRename.getBraidName(), batchLoader);
    }

    static class TopLevelDataFetcher
    implements DataFetcher<CompletableFuture<DataFetcherResult<Object>>> {
        private final String type;
        private final String field;

        TopLevelDataFetcher(String type, String field) {
            this.type = type;
            this.field = field;
        }

        public CompletableFuture<DataFetcherResult<Object>> get(DataFetchingEnvironment env) {
            DataLoader dataLoader = env.getDataLoader(DataFetcherUtils.getDataLoaderKey(this.type, this.field));
            CompletableFuture<DataFetcherResult<Object>> loadedValue = dataLoader.load((Object)env);
            DataLoader linkDataLoader = env.getDataLoader(DataFetcherUtils.getLinkDataLoaderKey(this.type, this.field));
            return linkDataLoader != null ? TopLevelDataFetcher.loadFromLinkLoader(env, loadedValue, (DataLoader<DataFetchingEnvironment, DataFetcherResult<Object>>)linkDataLoader) : loadedValue;
        }

        private static CompletableFuture<DataFetcherResult<Object>> loadFromLinkLoader(DataFetchingEnvironment env, Object source, DataLoader<DataFetchingEnvironment, DataFetcherResult<Object>> dataLoader) {
            DataFetchingEnvironment linkEnv = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment((DataFetchingEnvironment)env).source(source).fieldDefinition(env.getFieldDefinition()).build();
            return dataLoader.load((Object)linkEnv);
        }
    }

    private static class FieldDataLoaderRegistration {
        private final String type;
        private final String field;
        private final BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> loader;

        private FieldDataLoaderRegistration(String type, String field, BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> loader) {
            this.type = Objects.requireNonNull(type);
            this.field = Objects.requireNonNull(field);
            this.loader = Objects.requireNonNull(loader);
        }
    }

    private static final class RenamedFieldDefinition {
        private final FieldRename fieldRename;
        private final FieldDefinition definition;

        private RenamedFieldDefinition(FieldRename fieldRename, FieldDefinition definition) {
            this.fieldRename = fieldRename;
            this.definition = definition;
        }
    }
}

