/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.BatchLoaderEnvironment;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.transformation.BraidSchemaSource;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Map;

public class BraidingContext {
    private final Map<SchemaNamespace, BraidSchemaSource> dataSources;
    private final TypeDefinitionRegistry registry;
    private final RuntimeWiring.Builder runtimeWiringBuilder;
    private ObjectTypeDefinition queryObjectTypeDefinition;
    private ObjectTypeDefinition mutationObjectTypeDefinition;
    private final BatchLoaderEnvironment batchLoaderEnvironment;

    public BraidingContext(Map<SchemaNamespace, BraidSchemaSource> dataSources, TypeDefinitionRegistry registry, RuntimeWiring.Builder runtimeWiringBuilder, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition, BatchLoaderEnvironment batchLoaderEnvironment) {
        this.dataSources = dataSources;
        this.registry = registry;
        this.runtimeWiringBuilder = runtimeWiringBuilder;
        this.queryObjectTypeDefinition = queryObjectTypeDefinition;
        this.mutationObjectTypeDefinition = mutationObjectTypeDefinition;
        this.batchLoaderEnvironment = batchLoaderEnvironment;
    }

    public Map<SchemaNamespace, BraidSchemaSource> getDataSources() {
        return this.dataSources;
    }

    public TypeDefinitionRegistry getRegistry() {
        return this.registry;
    }

    public RuntimeWiring.Builder getRuntimeWiringBuilder() {
        return this.runtimeWiringBuilder;
    }

    void registerDataFetcher(String typeName, String fieldName, DataFetcher<?> dataFetcher) {
        this.runtimeWiringBuilder.type(typeName, builder -> builder.dataFetcher(fieldName, dataFetcher));
    }

    public ObjectTypeDefinition getQueryObjectTypeDefinition() {
        return this.queryObjectTypeDefinition;
    }

    public ObjectTypeDefinition getMutationObjectTypeDefinition() {
        return this.mutationObjectTypeDefinition;
    }

    BatchLoaderEnvironment getBatchLoaderEnvironment() {
        return this.batchLoaderEnvironment;
    }

    void updateQueryObjectTypeDefinition(ObjectTypeDefinition newQueryObjectTypeDefinition) {
        this.queryObjectTypeDefinition = newQueryObjectTypeDefinition;
        this.registry.remove((SDLDefinition)this.queryObjectTypeDefinition);
        this.registry.add((SDLDefinition)newQueryObjectTypeDefinition);
    }

    void updateMutationObjectTypeDefinition(ObjectTypeDefinition newMutationObjectTypeDefinition) {
        this.mutationObjectTypeDefinition = newMutationObjectTypeDefinition;
        this.registry.remove((SDLDefinition)this.mutationObjectTypeDefinition);
        this.registry.add((SDLDefinition)newMutationObjectTypeDefinition);
    }

    void setQueryObjectTypeDefinition(ObjectTypeDefinition queryObjectTypeDefinition) {
        this.queryObjectTypeDefinition = queryObjectTypeDefinition;
    }
}

