/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.Link;
import com.atlassian.braid.LinkArgument;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.transformation.BraidSchemaSource;
import graphql.execution.conditional.ConditionalNodes;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.SelectionSetContainer;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TrimFieldsSelection {
    public static FieldAndReferencedFragments trimFieldSelection(SchemaSource schemaSource, DataFetchingEnvironment environment, Field rootField, boolean skipTopLevelField) {
        BraidSchemaSource braidSchemaSource = new BraidSchemaSource(schemaSource);
        GraphQLSchema schema = environment.getGraphQLSchema();
        Map variables = environment.getVariables();
        LinkProcessor linkProcessor = new LinkProcessor(braidSchemaSource, schema, GraphQLTypeUtil.unwrapAll((GraphQLType)environment.getParentType()).getName(), variables, skipTopLevelField);
        Field newRootField = linkProcessor.field(rootField);
        Map fragmentsByName = environment.getFragmentsByName();
        Map<String, FragmentDefinition> newFragmentsByName = fragmentsByName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            FragmentDefinition fragment = (FragmentDefinition)entry.getValue();
            LinkProcessor fragmentLinkProcessor = new LinkProcessor(braidSchemaSource, schema, fragment.getTypeCondition().getName(), variables, skipTopLevelField);
            return fragmentLinkProcessor.fragmentDefinition(fragment);
        }));
        LinkedHashSet<FragmentDefinition> referencedFragments = new LinkedHashSet<FragmentDefinition>();
        TrimFieldsSelection.getReferencedFragments(newRootField, newFragmentsByName, referencedFragments);
        return new FieldAndReferencedFragments(newRootField, new ArrayList<FragmentDefinition>(referencedFragments));
    }

    private static boolean selectionSetContainsField(List<Selection> selections, Field fieldToCheck) {
        return selections.stream().filter(selection -> selection instanceof Field).map(field -> (Field)field).anyMatch(field -> field.getName().equals(fieldToCheck.getName()) && Objects.equals(field.getAlias(), fieldToCheck.getAlias()));
    }

    private static void getReferencedFragments(SelectionSetContainer<?> root, final Map<String, FragmentDefinition> fragmentDefinitionMap, Set<FragmentDefinition> referencedFragments) {
        final LinkedHashSet childFragments = new LinkedHashSet();
        NodeVisitorStub nodeVisitorStub = new NodeVisitorStub(){

            public TraversalControl visitFragmentSpread(FragmentSpread fragmentSpread, TraverserContext<Node> context) {
                childFragments.add((FragmentDefinition)fragmentDefinitionMap.get(fragmentSpread.getName()));
                return TraversalControl.CONTINUE;
            }
        };
        new NodeTraverser().preOrder((NodeVisitor)nodeVisitorStub, root);
        childFragments.stream().filter(referencedFragments::add).forEach(frag -> TrimFieldsSelection.getReferencedFragments(frag, fragmentDefinitionMap, referencedFragments));
    }

    private static class LinkProcessor {
        private final ConditionalNodes conditionalNodes = new ConditionalNodes();
        private final BraidSchemaSource braidSchemaSource;
        private final GraphQLSchema schema;
        private final Map<String, Object> variables;
        private final boolean skipTopLevelField;
        private final Deque<String> typeStack;

        private LinkProcessor(BraidSchemaSource braidSchemaSource, GraphQLSchema schema, String parentType, Map<String, Object> variables, boolean skipTopLevelField) {
            this.braidSchemaSource = braidSchemaSource;
            this.schema = schema;
            this.variables = variables;
            this.skipTopLevelField = skipTopLevelField;
            this.typeStack = new ArrayDeque<String>();
            this.typeStack.push(parentType);
        }

        public Field field(Field node) {
            Link link;
            boolean isTopLevelField;
            if (node.getSelectionSet() == null) {
                return node;
            }
            boolean bl = isTopLevelField = this.typeStack.size() == 1;
            if (isTopLevelField && !this.skipTopLevelField && (link = this.getLinkForField(node)) != null) {
                LinkArgument linkArgument = link.getLinkArguments().stream().filter(argument -> argument.getArgumentSource() == LinkArgument.ArgumentSource.OBJECT_FIELD).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Link for top level field '%s' requires exactly one object field argument", link.getNewFieldName())));
                return node.transform(builder -> builder.name(linkArgument.getSourceName()).selectionSet(null).build());
            }
            GraphQLFieldsContainer parentType = (GraphQLFieldsContainer)this.schema.getType(this.typeStack.peek());
            GraphQLOutputType fieldType = parentType.getFieldDefinition(node.getName()).getType();
            this.typeStack.push(GraphQLTypeUtil.unwrapAll((GraphQLType)fieldType).getName());
            Field newNode = node.transform(builder -> builder.selectionSet(this.newSelectionSet(node.getSelectionSet())));
            this.typeStack.pop();
            return newNode;
        }

        public InlineFragment inlineFragment(InlineFragment node) {
            this.typeStack.push(node.getTypeCondition().getName());
            InlineFragment newNode = node.transform(builder -> builder.selectionSet(this.newSelectionSet(node.getSelectionSet())));
            this.typeStack.pop();
            return newNode;
        }

        public FragmentDefinition fragmentDefinition(FragmentDefinition node) {
            return node.transform(builder -> builder.selectionSet(this.newSelectionSet(node.getSelectionSet())));
        }

        private SelectionSet newSelectionSet(SelectionSet selectionSet) {
            ArrayList<Field> newSelections = new ArrayList<Field>();
            selectionSet.getSelections().forEach(selection -> {
                if (selection instanceof Field) {
                    Field field = (Field)selection;
                    if (!this.conditionalNodes.shouldInclude(this.variables, field.getDirectives())) {
                        return;
                    }
                    Link linkForField = this.getLinkForField(field);
                    if (linkForField != null) {
                        linkForField.getLinkArguments().stream().filter(argument -> argument.getArgumentSource() == LinkArgument.ArgumentSource.OBJECT_FIELD).forEach(argument -> {
                            Field newField = Field.newField().name(argument.getSourceName()).build();
                            if (!TrimFieldsSelection.selectionSetContainsField(newSelections, newField)) {
                                newSelections.add(newField);
                            }
                        });
                    } else {
                        newSelections.add(this.field(field));
                    }
                } else if (selection instanceof InlineFragment) {
                    InlineFragment inlineFragment = (InlineFragment)selection;
                    if (!this.conditionalNodes.shouldInclude(this.variables, inlineFragment.getDirectives())) {
                        return;
                    }
                    newSelections.add((Field)this.inlineFragment(inlineFragment));
                } else if (selection instanceof FragmentSpread) {
                    FragmentSpread fragmentSpread = (FragmentSpread)selection;
                    if (!this.conditionalNodes.shouldInclude(this.variables, fragmentSpread.getDirectives())) {
                        return;
                    }
                    newSelections.add((Field)fragmentSpread);
                }
            });
            if (newSelections.size() == 0) {
                newSelections.add(new Field(Introspection.TypeNameMetaFieldDef.getName()));
            }
            return SelectionSet.newSelectionSet().selections(newSelections).build();
        }

        private Link getLinkForField(Field field) {
            String typeName = this.typeStack.peek();
            String fieldName = field.getName();
            return this.braidSchemaSource.getSchemaSource().getLinks().stream().filter(link -> this.braidSchemaSource.getLinkBraidSourceType((Link)link).equals(typeName) && link.getNewFieldName().equals(fieldName)).findFirst().orElse(null);
        }
    }

    public static class FieldAndReferencedFragments {
        public final Field field;
        public final List<FragmentDefinition> referencedFragments;

        private FieldAndReferencedFragments(Field field, List<FragmentDefinition> referencedFragments) {
            this.field = field;
            this.referencedFragments = referencedFragments;
        }
    }
}

