/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.CustomMapper;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.MapperMaps;
import com.atlassian.braid.mapper.MapperOperation;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

final class CustomOperation
implements MapperOperation {
    private final CustomMapper customMapper;
    private final String key;

    public CustomOperation(String key, String className, Mapper mapper, Map<String, Object> args) {
        try {
            this.key = key;
            Class<?> clazz = Class.forName(className);
            this.customMapper = (CustomMapper)clazz.getDeclaredConstructor(Mapper.class, Map.class).newInstance(mapper, args);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void accept(Map<String, Object> input, Map<String, Object> output) {
        HashMap<String, Object> newInput = new HashMap<String, Object>();
        Object inputValue = MapperMaps.get(input, this.key).orElse(null);
        newInput.put(this.key, inputValue);
        this.customMapper.transform(newInput, output);
    }
}

