/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.graphql.language;

import com.atlassian.braid.graphql.language.DefinitionTraversalContext;
import com.atlassian.braid.graphql.language.NodeTransformer;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SelectionSet;
import graphql.language.TypeDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.validation.DocumentVisitor;
import graphql.validation.LanguageTraversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoveUnknownFields
implements DocumentVisitor {
    private final DefinitionTraversalContext traversalContext;
    private final String sourceTypeName;
    private final Map<String, Field> removedFields = new HashMap<String, Field>();
    private final Node node;
    private final Set<String> originalTypeFieldNames;
    private final List<Field> fieldsToRemove = new ArrayList<Field>();
    private final Document document;

    RemoveUnknownFields(TypeDefinitionRegistry sourceSchema, Set<String> originalTypeFieldNames, String sourceTypeName, Document node) {
        this.traversalContext = new DefinitionTraversalContext(sourceSchema);
        this.sourceTypeName = sourceTypeName;
        this.originalTypeFieldNames = originalTypeFieldNames;
        this.node = node;
        this.document = this.execute(node);
    }

    private Document execute(Document node) {
        LanguageTraversal languageTraversal = new LanguageTraversal();
        languageTraversal.traverse(this.node, (DocumentVisitor)this);
        this.fieldsToRemove.forEach(f -> this.removedFields.put(f.getName(), (Field)f));
        NodeTransformer transformer = new NodeTransformer(){

            @Override
            public SelectionSet selectionSet(SelectionSet node) {
                if (node == null) {
                    return null;
                }
                List selections = node.getSelections().stream().filter(s -> RemoveUnknownFields.this.fieldsToRemove.stream().noneMatch(f -> s.hashCode() == f.hashCode())).collect(Collectors.toList());
                if (selections.isEmpty()) {
                    return null;
                }
                return node.transform(b -> b.selections((Collection)selections.stream().map(this::selection).collect(Collectors.toList())));
            }
        };
        return transformer.document(node);
    }

    List<Field> getFields() {
        return new ArrayList<Field>(this.removedFields.values());
    }

    Document getDocument() {
        return this.document;
    }

    public void enter(Node node, List<Node> path) {
        this.traversalContext.enter(node, path);
        if (node instanceof Field) {
            this.checkField(this.traversalContext.getParentType(), path.isEmpty() ? Optional.empty() : Optional.of((SelectionSet)path.get(path.size() - 1)));
        }
    }

    private void checkField(TypeDefinition parentType, Optional<SelectionSet> parent) {
        if (parentType instanceof ObjectTypeDefinition && parentType.getName().equals(this.sourceTypeName)) {
            parent.ifPresent(selectionSet -> selectionSet.getSelections().stream().filter(s -> s instanceof Field).filter(s -> !this.originalTypeFieldNames.contains(((Field)s).getName())).filter(s -> !((Field)s).getName().startsWith("__")).forEach(s -> this.fieldsToRemove.add((Field)s)));
        }
    }

    public void leave(Node node, List<Node> path) {
        this.traversalContext.leave(node, path);
    }
}

