package com.atlassian.braid.mapper;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

final class CustomOperation implements MapperOperation {
    private final CustomMapper customMapper;
    private final String key;

    public CustomOperation(String key,
                           String className,
                           Mapper mapper,
                           Map<String, Object> args) {
        try {
            this.key = key;
            Class<?> clazz = Class.forName(className);
            this.customMapper = (CustomMapper) clazz.getDeclaredConstructor(com.atlassian.braid.mapper.Mapper.class, Map.class).newInstance(mapper, args);
        } catch (NoSuchMethodException |
                 InstantiationException |
                 IllegalAccessException |
                 InvocationTargetException |
                 ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void accept(Map<String, Object> input, Map<String, Object> output) {
        Map<String, Object> newInput = new HashMap<>();
        Object inputValue = MapperMaps.get(input, this.key).orElse(null);
        newInput.put(this.key, inputValue);
        customMapper.transform(newInput, output);
    }
}
