/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Extension;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.source.NamespacedVariableReference;
import com.atlassian.braid.transformation.FieldWithCounter;
import com.atlassian.braid.transformation.QueryTransformationUtils;
import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.InputValueDefinition;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ExtensionTransformation
implements FieldTransformation {
    private final Extension extension;

    ExtensionTransformation(Extension extension) {
        this.extension = Objects.requireNonNull(extension);
    }

    @Override
    public CompletableFuture<List<Field>> apply(DataFetchingEnvironment environment, FieldTransformationContext context) {
        Map source;
        if (environment.getSource() instanceof DataFetcherResult) {
            source = (Map)((DataFetcherResult)environment.getSource()).getData();
        } else if (environment.getSource() instanceof Map) {
            source = (Map)environment.getSource();
        } else {
            throw new IllegalArgumentException("Unexpected source type: " + environment.getSource());
        }
        Object targetId = source.get(this.extension.getOn());
        OperationDefinition operationDefinition = environment.getOperationDefinition();
        FieldWithCounter field = QueryTransformationUtils.cloneTrimAndAliasField(context, new ArrayList<Integer>(), environment, true);
        this.addQueryVariable(context, targetId, field);
        List<Field> missingFields = ((BraidContext)environment.getContext()).getMissingFields(GraphQLTypeUtil.unwrapAll((GraphQLType)environment.getFieldType()).getName());
        SelectionSet selectionSet = SelectionSet.newSelectionSet().selections(missingFields).build();
        field.field = field.field.transform(builder -> builder.selectionSet(selectionSet));
        QueryTransformationUtils.addFieldToQuery(context, environment, operationDefinition, field);
        return CompletableFuture.completedFuture(Collections.singletonList(field.field));
    }

    private void addQueryVariable(FieldTransformationContext fieldTransformationContext, Object targetId, FieldWithCounter field) {
        String variableName = this.extension.getBy().getArg() + fieldTransformationContext.getCounter();
        field.field = field.field.transform(builder -> builder.name(this.extension.getBy().getQuery()).arguments(ExtensionTransformation.linkQueryArgumentAsList(this.extension, variableName)));
        fieldTransformationContext.addVariableDefinition(ExtensionTransformation.linkQueryVariableDefinition(this.extension, variableName, fieldTransformationContext.getSchemaSource()));
        fieldTransformationContext.getVariables().put(variableName, targetId);
    }

    private static List<Argument> linkQueryArgumentAsList(Extension link, String variableName) {
        return Collections.singletonList(new Argument(link.getBy().getArg(), (Value)NamespacedVariableReference.namespacedVariableReference(variableName)));
    }

    private static VariableDefinition linkQueryVariableDefinition(Extension link, String variableName, SchemaSource schemaSource) {
        return new VariableDefinition(variableName, ExtensionTransformation.findArgumentType(schemaSource, link));
    }

    private static Type findArgumentType(SchemaSource schemaSource, Extension link) {
        return TypeUtils.findQueryFieldDefinitions(schemaSource.getPrivateSchema()).orElseThrow(IllegalStateException::new).stream().filter(f -> f.getName().equals(link.getBy().getQuery())).findFirst().map(f -> f.getInputValueDefinitions().stream().filter(iv -> iv.getName().equals(link.getBy().getArg())).findFirst().map(InputValueDefinition::getType).orElseThrow(IllegalArgumentException::new)).orElseThrow(IllegalArgumentException::new);
    }
}

