package com.atlassian.braid.source;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static java.util.Objects.requireNonNull;

/**
 * Wraps an error and create absolute path.
 */
public class RelativeGraphQLError implements GraphQLError {
    private final GraphQLError delegate;
    private final List<Object> absolutePath;

    RelativeGraphQLError(GraphQLError delegate, ResultPath basePath) {
        this.delegate = requireNonNull(delegate);

        absolutePath = new ArrayList<>();
        absolutePath.addAll(requireNonNull(basePath).toList());

        List<Object> relativePath = delegate.getPath();
        if (relativePath != null &&  !relativePath.isEmpty()) {
            absolutePath.addAll(relativePath.subList(1, delegate.getPath().size()));
        }
    }

    /**
     * Creates a new RelativeGraphQLError with a new base path.
     */
    public RelativeGraphQLError updateBasePath(ResultPath basePath) {
        return new RelativeGraphQLError(delegate, basePath);
    }

    @Override
    public String getMessage() {
        return delegate.getMessage();
    }

    @Override
    public List<SourceLocation> getLocations() {
        return delegate.getLocations();
    }

    @Override
    public ErrorClassification getErrorType() {
        return delegate.getErrorType();
    }

    @Override
    public List<Object> getPath() {
        return absolutePath;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return delegate.getExtensions();
    }
}
