/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.java.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class CompletableListCollector<K, V>
implements Collector<CompletionStage<Map<K, V>>, List<CompletableFuture<Map<K, V>>>, CompletionStage<List<V>>> {
    private List<K> keys;

    public CompletableListCollector(List<K> keys) {
        this.keys = keys;
    }

    @Override
    public Supplier<List<CompletableFuture<Map<K, V>>>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<CompletableFuture<Map<K, V>>>, CompletionStage<Map<K, V>>> accumulator() {
        return (list, item) -> list.add(item.toCompletableFuture());
    }

    @Override
    public BinaryOperator<List<CompletableFuture<Map<K, V>>>> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<List<CompletableFuture<Map<K, V>>>, CompletionStage<List<V>>> finisher() {
        return list -> CompletableFuture.allOf(list.toArray(new CompletableFuture[list.size()])).thenApply(v -> {
            Map<Object, Object> results = list.stream().map(CompletableFuture::join).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return this.keys.stream().map(results::get).collect(Collectors.toList());
        });
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

