/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.graphql.language;

import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class NodeTransformer {
    public Argument argument(Argument node) {
        return node.transform(b -> b.value(this.value(node.getValue())));
    }

    public ArrayValue arrayValue(ArrayValue node) {
        return node.transform(b -> b.values(node.getValues().stream().map(this::value).collect(Collectors.toList())));
    }

    public BooleanValue booleanValue(BooleanValue node) {
        return node;
    }

    public Directive directive(Directive node) {
        return node.transform(b -> b.arguments(this.arguments(node.getArguments())));
    }

    public DirectiveDefinition directiveDefinition(DirectiveDefinition node) {
        return node.transform(b -> b.inputValueDefinitions(this.inputValues(node.getInputValueDefinitions())).directiveLocations(node.getDirectiveLocations().stream().map(this::directiveLocation).collect(Collectors.toList())));
    }

    public DirectiveLocation directiveLocation(DirectiveLocation node) {
        return node;
    }

    public Document document(Document node) {
        return node.transform(b -> b.definitions(node.getDefinitions().stream().map(this::definition).collect(Collectors.toList())));
    }

    public EnumTypeDefinition enumTypeDefinition(EnumTypeDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())).enumValueDefinitions(node.getEnumValueDefinitions().stream().map(this::enumValueDefinition).collect(Collectors.toList())));
    }

    public EnumValue enumValue(EnumValue node) {
        return node;
    }

    public EnumValueDefinition enumValueDefinition(EnumValueDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())));
    }

    public Field field(Field node) {
        return node.transform(b -> b.arguments(this.arguments(node.getArguments())).selectionSet(this.selectionSet(node.getSelectionSet())).directives(this.directives(node.getDirectives())));
    }

    public FieldDefinition fieldDefinition(FieldDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())).type(this.type(node.getType())).inputValueDefinitions(this.inputValues(node.getInputValueDefinitions())));
    }

    public FloatValue floatValue(FloatValue node) {
        return node;
    }

    public FragmentDefinition fragmentDefinition(FragmentDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())).selectionSet(this.selectionSet(node.getSelectionSet())).typeCondition(this.typeName(node.getTypeCondition())));
    }

    public FragmentSpread fragmentSpread(FragmentSpread node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())));
    }

    public InlineFragment inlineFragment(InlineFragment node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())).selectionSet(this.selectionSet(node.getSelectionSet())).typeCondition(this.typeName(node.getTypeCondition())));
    }

    public InputObjectTypeDefinition inputObjectTypeDefinition(InputObjectTypeDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())).inputValueDefinitions(this.inputValues(node.getInputValueDefinitions())));
    }

    public InputValueDefinition inputValueDefinition(InputValueDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())));
    }

    public IntValue intValue(IntValue node) {
        return node;
    }

    public InterfaceTypeDefinition interfaceTypeDefinition(InterfaceTypeDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())).definitions(this.fieldDefinitions(node.getFieldDefinitions())));
    }

    public ListType listType(ListType node) {
        return node.transform(b -> b.type(this.type(node.getType())));
    }

    public NonNullType nonNullType(NonNullType node) {
        return node.transform(b -> b.type(this.type(node.getType())));
    }

    public NullValue nullValue(NullValue node) {
        return node;
    }

    public ObjectField objectField(ObjectField node) {
        return node;
    }

    public ObjectTypeDefinition objectTypeDefinition(ObjectTypeDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())).fieldDefinitions(this.fieldDefinitions(node.getFieldDefinitions())));
    }

    public ObjectValue objectValue(ObjectValue node) {
        return node.transform(b -> b.objectFields(node.getObjectFields().stream().map(this::objectField).collect(Collectors.toList())));
    }

    public OperationDefinition operationDefinition(OperationDefinition node) {
        return node.transform(b -> b.variableDefinitions(node.getVariableDefinitions().stream().map(this::variableDefinition).collect(Collectors.toList())).selectionSet(this.selectionSet(node.getSelectionSet())).directives(this.directives(node.getDirectives())));
    }

    public OperationTypeDefinition operationTypeDefinition(OperationTypeDefinition node) {
        return node.transform(b -> b.typeName(this.typeName(node.getTypeName())));
    }

    public ScalarTypeDefinition scalarTypeDefinition(ScalarTypeDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())));
    }

    public SchemaDefinition schemaDefinition(SchemaDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())).operationTypeDefinitions(node.getOperationTypeDefinitions().stream().map(this::operationTypeDefinition).collect(Collectors.toList())));
    }

    public SelectionSet selectionSet(SelectionSet node) {
        if (node == null) {
            return null;
        }
        return node.transform(b -> b.selections((Collection)node.getSelections().stream().map(this::selection).collect(Collectors.toList())));
    }

    public StringValue stringValue(StringValue node) {
        return node;
    }

    public TypeName typeName(TypeName node) {
        return node;
    }

    public UnionTypeDefinition unionTypeDefinition(UnionTypeDefinition node) {
        return node.transform(b -> b.directives(this.directives(node.getDirectives())).memberTypes(node.getMemberTypes().stream().map(this::type).collect(Collectors.toList())));
    }

    public VariableDefinition variableDefinition(VariableDefinition node) {
        return node.transform(b -> b.type(this.type(node.getType())));
    }

    public VariableReference variableReference(VariableReference node) {
        return node;
    }

    protected Value value(Value value) {
        if (value instanceof ArrayValue) {
            return this.arrayValue((ArrayValue)value);
        }
        if (value instanceof BooleanValue) {
            return this.booleanValue((BooleanValue)value);
        }
        if (value instanceof EnumValue) {
            return this.enumValue((EnumValue)value);
        }
        if (value instanceof FloatValue) {
            return this.floatValue((FloatValue)value);
        }
        if (value instanceof IntValue) {
            return this.intValue((IntValue)value);
        }
        if (value instanceof ObjectValue) {
            return this.objectValue((ObjectValue)value);
        }
        if (value instanceof NullValue) {
            return this.nullValue((NullValue)value);
        }
        if (value instanceof StringValue) {
            return this.stringValue((StringValue)value);
        }
        if (value instanceof VariableReference) {
            return this.variableReference((VariableReference)value);
        }
        return value;
    }

    protected Definition definition(Definition def) {
        if (def instanceof DirectiveDefinition) {
            return this.directiveDefinition((DirectiveDefinition)def);
        }
        if (def instanceof EnumTypeDefinition) {
            return this.enumTypeDefinition((EnumTypeDefinition)def);
        }
        if (def instanceof FragmentDefinition) {
            return this.fragmentDefinition((FragmentDefinition)def);
        }
        if (def instanceof InputObjectTypeDefinition) {
            return this.inputObjectTypeDefinition((InputObjectTypeDefinition)def);
        }
        if (def instanceof InterfaceTypeDefinition) {
            return this.interfaceTypeDefinition((InterfaceTypeDefinition)def);
        }
        if (def instanceof ObjectTypeDefinition) {
            return this.objectTypeDefinition((ObjectTypeDefinition)def);
        }
        if (def instanceof OperationDefinition) {
            return this.operationDefinition((OperationDefinition)def);
        }
        if (def instanceof ScalarTypeDefinition) {
            return this.scalarTypeDefinition((ScalarTypeDefinition)def);
        }
        if (def instanceof SchemaDefinition) {
            return this.schemaDefinition((SchemaDefinition)def);
        }
        if (def instanceof UnionTypeDefinition) {
            return this.unionTypeDefinition((UnionTypeDefinition)def);
        }
        return def;
    }

    protected Type type(Type type) {
        if (type instanceof ListType) {
            return this.listType((ListType)type);
        }
        if (type instanceof NonNullType) {
            return this.nonNullType((NonNullType)type);
        }
        if (type instanceof TypeName) {
            return this.typeName((TypeName)type);
        }
        return type;
    }

    protected Selection selection(Selection sel) {
        if (sel instanceof Field) {
            return this.field((Field)sel);
        }
        if (sel instanceof FragmentSpread) {
            return this.fragmentSpread((FragmentSpread)sel);
        }
        if (sel instanceof InlineFragment) {
            return this.inlineFragment((InlineFragment)sel);
        }
        return sel;
    }

    private List<InputValueDefinition> inputValues(List<InputValueDefinition> inputValueDefinitions) {
        return inputValueDefinitions.stream().map(this::inputValueDefinition).collect(Collectors.toList());
    }

    private List<Directive> directives(List<Directive> directives) {
        return directives.stream().map(this::directive).collect(Collectors.toList());
    }

    private List<FieldDefinition> fieldDefinitions(List<FieldDefinition> fieldDefinitions) {
        return fieldDefinitions.stream().map(this::fieldDefinition).collect(Collectors.toList());
    }

    private List<Argument> arguments(List<Argument> arguments) {
        return arguments.stream().map(this::argument).collect(Collectors.toList());
    }
}

