/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.graphql.language;

import com.atlassian.braid.TypeUtils;
import graphql.Assert;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FragmentDefinition;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.validation.DocumentVisitor;
import java.util.ArrayList;
import java.util.List;

public class DefinitionTraversalContext
implements DocumentVisitor {
    private final TypeDefinitionRegistry registry;
    private final List<TypeDefinition> outputTypeStack = new ArrayList<TypeDefinition>();
    private final List<TypeDefinition> parentTypeStack = new ArrayList<TypeDefinition>();
    private final List<TypeDefinition> inputTypeStack = new ArrayList<TypeDefinition>();
    private final List<FieldDefinition> fieldDefStack = new ArrayList<FieldDefinition>();
    private final List<String> nameStack = new ArrayList<String>();

    DefinitionTraversalContext(TypeDefinitionRegistry typeDefinitionRegistry) {
        this.registry = typeDefinitionRegistry;
    }

    public void enter(Node node, List<Node> path) {
        if (node instanceof OperationDefinition) {
            this.enterImpl((OperationDefinition)node);
        } else if (node instanceof SelectionSet) {
            this.enterImpl((SelectionSet)node);
        } else if (node instanceof Field) {
            this.enterImpl((Field)node);
        } else if (!(node instanceof Directive)) {
            if (node instanceof InlineFragment) {
                this.enterImpl((InlineFragment)node);
            } else if (node instanceof FragmentDefinition) {
                this.enterImpl((FragmentDefinition)node);
            } else if (node instanceof VariableDefinition) {
                this.enterImpl((VariableDefinition)node);
            } else if (node instanceof Argument) {
                this.enterImpl((Argument)node);
            } else if (node instanceof ArrayValue) {
                this.enterImpl((ArrayValue)node);
            } else if (node instanceof ObjectField) {
                // empty if block
            }
        }
    }

    private void enterImpl(SelectionSet selectionSet) {
        this.addParentType(this.getOutputType());
    }

    private void enterImpl(Field field) {
        this.enterName(field.getName());
        TypeDefinition parentType = this.getParentType();
        FieldDefinition fieldDefinition = null;
        if (parentType != null) {
            fieldDefinition = this.getFieldDef(this.registry, parentType, field);
        }
        this.addFieldDef(fieldDefinition);
        this.addOutputType(fieldDefinition != null && fieldDefinition.getType() != null ? (TypeDefinition)this.registry.getType(fieldDefinition.getType()).orElse(null) : null);
    }

    private void enterImpl(OperationDefinition operationDefinition) {
        if (operationDefinition.getOperation() == OperationDefinition.Operation.MUTATION) {
            this.addOutputType((TypeDefinition)TypeUtils.findMutationType(this.registry).orElseThrow(IllegalStateException::new));
        } else if (operationDefinition.getOperation() == OperationDefinition.Operation.QUERY) {
            this.addOutputType((TypeDefinition)TypeUtils.findQueryType(this.registry).orElseThrow(IllegalStateException::new));
        } else {
            if (operationDefinition.getOperation() == OperationDefinition.Operation.SUBSCRIPTION) {
                throw new UnsupportedOperationException("subscriptions not supported yet");
            }
            Assert.assertShouldNeverHappen();
        }
    }

    private void enterImpl(InlineFragment inlineFragment) {
        TypeName typeCondition = inlineFragment.getTypeCondition();
        TypeDefinition type = typeCondition != null ? (TypeDefinition)this.registry.getType(typeCondition.getName()).orElseThrow(IllegalArgumentException::new) : this.getParentType();
        this.addOutputType(type);
    }

    private void enterImpl(FragmentDefinition fragmentDefinition) {
        this.enterName(fragmentDefinition.getName());
        TypeDefinition type = (TypeDefinition)this.registry.getType(fragmentDefinition.getTypeCondition().getName()).orElseThrow(IllegalStateException::new);
        this.addOutputType(type);
    }

    private void enterImpl(VariableDefinition variableDefinition) {
        TypeDefinition type = DefinitionTraversalContext.getTypeDefinitionFromAST(this.registry, variableDefinition.getType());
        this.addInputType((TypeDefinition)(type instanceof InputObjectTypeDefinition ? (InputObjectTypeDefinition)type : null));
    }

    private static TypeDefinition getTypeDefinitionFromAST(TypeDefinitionRegistry registry, Type type) {
        if (type instanceof ListType) {
            return DefinitionTraversalContext.getTypeDefinitionFromAST(registry, ((ListType)type).getType());
        }
        if (type instanceof NonNullType) {
            return DefinitionTraversalContext.getTypeDefinitionFromAST(registry, ((NonNullType)type).getType());
        }
        return (TypeDefinition)registry.getType(((TypeName)type).getName()).orElseThrow(IllegalArgumentException::new);
    }

    private void enterImpl(Argument argument) {
        InputValueDefinition argumentType = null;
        if (this.getFieldDef() != null) {
            argumentType = this.find(this.getFieldDef().getInputValueDefinitions(), argument.getName());
        }
        this.addInputType(argumentType != null ? (TypeDefinition)this.registry.getType(argumentType.getType()).orElse(null) : null);
    }

    private void enterImpl(ArrayValue arrayValue) {
        this.addInputType(this.getInputType());
    }

    private InputValueDefinition find(List<InputValueDefinition> arguments, String name) {
        for (InputValueDefinition argument : arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    public void leave(Node node, List<Node> ancestors) {
        if (node instanceof OperationDefinition) {
            this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
        } else if (node instanceof SelectionSet) {
            this.parentTypeStack.remove(this.parentTypeStack.size() - 1);
        } else if (node instanceof Field) {
            this.leaveName(((Field)node).getName());
            this.fieldDefStack.remove(this.fieldDefStack.size() - 1);
            this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
        } else if (!(node instanceof Directive)) {
            if (node instanceof InlineFragment) {
                this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
            } else if (node instanceof FragmentDefinition) {
                this.leaveName(((FragmentDefinition)node).getName());
                this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
            } else if (node instanceof VariableDefinition) {
                this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
            } else if (node instanceof Argument) {
                this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
            } else if (node instanceof ArrayValue) {
                this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
            } else if (node instanceof ObjectField) {
                // empty if block
            }
        }
    }

    private void enterName(String name) {
        if (!this.isEmpty(name)) {
            this.nameStack.add(name);
        }
    }

    private void leaveName(String name) {
        if (!this.isEmpty(name)) {
            this.nameStack.remove(this.nameStack.size() - 1);
        }
    }

    private boolean isEmpty(String name) {
        return name == null || name.isEmpty();
    }

    private GraphQLNullableType getNullableType(GraphQLType type) {
        return (GraphQLNullableType)(GraphQLTypeUtil.isNonNull((GraphQLType)type) ? GraphQLTypeUtil.unwrapOne((GraphQLType)type) : type);
    }

    public TypeDefinition getOutputType() {
        return this.lastElement(this.outputTypeStack);
    }

    private void addOutputType(TypeDefinition type) {
        this.outputTypeStack.add(type);
    }

    private <T> T lastElement(List<T> list) {
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public TypeDefinition getParentType() {
        return this.lastElement(this.parentTypeStack);
    }

    private void addParentType(TypeDefinition compositeType) {
        this.parentTypeStack.add(compositeType);
    }

    public TypeDefinition getInputType() {
        return this.lastElement(this.inputTypeStack);
    }

    private void addInputType(TypeDefinition graphQLInputType) {
        this.inputTypeStack.add(graphQLInputType);
    }

    public FieldDefinition getFieldDef() {
        return this.lastElement(this.fieldDefStack);
    }

    public List<String> getQueryPath() {
        if (this.nameStack.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.nameStack);
    }

    private void addFieldDef(FieldDefinition fieldDefinition) {
        this.fieldDefStack.add(fieldDefinition);
    }

    private FieldDefinition getFieldDef(TypeDefinitionRegistry registry, TypeDefinition parentType, Field field) {
        if (TypeUtils.findQueryType(registry).map(def -> def.equals(parentType)).orElse(false).booleanValue()) {
            if (field.getName().equals(Introspection.SchemaMetaFieldDef.getName())) {
                return FieldDefinition.newFieldDefinition().name(Introspection.SchemaMetaFieldDef.getName()).build();
            }
            if (field.getName().equals(Introspection.TypeMetaFieldDef.getName())) {
                return FieldDefinition.newFieldDefinition().name(Introspection.TypeMetaFieldDef.getName()).build();
            }
        }
        if (field.getName().equals(Introspection.TypeNameMetaFieldDef.getName()) && (parentType instanceof ObjectTypeDefinition || parentType instanceof InterfaceTypeDefinition || parentType instanceof UnionTypeDefinition)) {
            return FieldDefinition.newFieldDefinition().name(Introspection.TypeNameMetaFieldDef.getName()).build();
        }
        if (parentType instanceof ObjectTypeDefinition) {
            return ((ObjectTypeDefinition)parentType).getFieldDefinitions().stream().filter(fd -> fd.getName().equals(field.getName())).findFirst().orElse(null);
        }
        return null;
    }
}

