/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.ArgumentValueProvider;
import com.atlassian.braid.BatchLoaderUtils;
import com.atlassian.braid.LinkArgument;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class DefaultArgumentValueProvider
implements ArgumentValueProvider {
    public static final ArgumentValueProvider INSTANCE = new DefaultArgumentValueProvider();
    private final Map<String, Object> staticValues;

    private DefaultArgumentValueProvider() {
        this.staticValues = Collections.emptyMap();
    }

    public DefaultArgumentValueProvider(@Nullable Map<String, Object> staticValues) {
        this.staticValues = Optional.ofNullable(staticValues).map(Collections::unmodifiableMap).orElse(Collections.emptyMap());
    }

    @Override
    public CompletableFuture<Object> fetchValueForArgument(LinkArgument linkArgument, DataFetchingEnvironment environment) {
        switch (linkArgument.getArgumentSource()) {
            case OBJECT_FIELD: {
                return BatchLoaderUtils.getFieldValue(environment, linkArgument.getSourceName()).thenApply(v -> v.orElse(null));
            }
            case CONTEXT: {
                throw new UnsupportedOperationException("not supported in default implementation");
            }
            case FIELD_ARGUMENT: {
                return CompletableFuture.completedFuture(environment.getArgument(linkArgument.getSourceName()));
            }
            case STATIC: {
                return CompletableFuture.completedFuture(this.staticValues.get(linkArgument.getSourceName()));
            }
        }
        throw new UnsupportedOperationException("Unsupported argument source.");
    }
}

