/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.Extension;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class AbstractSchemaSource
implements SchemaSource {
    private final SchemaNamespace namespace;
    private final TypeDefinitionRegistry schema;
    private final TypeDefinitionRegistry privateSchema;
    private final List<Link> links;
    private final List<Extension> extensions;
    private final String operationNamePrefix;

    public AbstractSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry schema, TypeDefinitionRegistry privateSchema, List<Link> links, List<Extension> extensions) {
        this(namespace, schema, privateSchema, links, extensions, null);
    }

    public AbstractSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry schema, TypeDefinitionRegistry privateSchema, List<Link> links, List<Extension> extensions, String operationNamePrefix) {
        this.namespace = Objects.requireNonNull(namespace);
        this.schema = Objects.requireNonNull(schema);
        this.privateSchema = Objects.requireNonNull(privateSchema);
        this.links = new ArrayList<Link>((Collection)Objects.requireNonNull(links));
        this.extensions = new ArrayList<Extension>((Collection)Objects.requireNonNull(extensions));
        this.operationNamePrefix = operationNamePrefix;
    }

    @Override
    public final SchemaNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public final TypeDefinitionRegistry getSchema() {
        return this.schema;
    }

    @Override
    public final TypeDefinitionRegistry getPrivateSchema() {
        return this.privateSchema;
    }

    @Override
    public final List<Link> getLinks() {
        return new ArrayList<Link>(this.links);
    }

    @Override
    public final List<Extension> getExtensions() {
        return new ArrayList<Extension>(this.extensions);
    }

    @Override
    public final String getOperationNamePrefix() {
        return this.operationNamePrefix;
    }
}

