/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.BatchLoaderUtils;
import com.atlassian.braid.FieldKey;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.transformation.FieldWithCounter;
import com.atlassian.braid.transformation.QueryTransformationUtils;
import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.InputValueDefinition;
import graphql.language.OperationDefinition;
import graphql.language.Type;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class LinkTransformation
implements FieldTransformation {
    private final Link link;

    LinkTransformation(Link link) {
        this.link = Objects.requireNonNull(link);
    }

    public Link getLink() {
        return this.link;
    }

    @Override
    public CompletableFuture<List<Field>> apply(DataFetchingEnvironment environment, FieldTransformationContext context) {
        ArrayList usedCounterIds = new ArrayList();
        OperationDefinition operationDefinition = QueryTransformationUtils.getOperationDefinition(environment);
        return BatchLoaderUtils.getTargetIdsFromEnvironment(this.link, environment).thenApply(targetIds -> {
            ArrayList<Field> fields = new ArrayList<Field>();
            Field cloneOfCurrentField = environment.getField().deepCopy();
            boolean onlyTargetFieldMatchingQueryArgumentSelected = LinkTransformation.isOnlyTargetFieldMatchingQueryArgumentSelected(cloneOfCurrentField, this.link);
            for (final Object targetId : targetIds) {
                FieldWithCounter field = QueryTransformationUtils.cloneTrimAndAliasField(context, usedCounterIds, environment, true);
                if (LinkTransformation.isTargetIdNullAndCannotQueryLinkWithNull(targetId, this.link)) {
                    context.getShortCircuitedData().put(new FieldKey(field.field.getAlias()), null);
                } else if (onlyTargetFieldMatchingQueryArgumentSelected) {
                    context.getShortCircuitedData().put(new FieldKey(field.field.getAlias()), new HashMap<String, Object>(){
                        {
                            this.put(LinkTransformation.this.link.getTargetFieldMatchingQueryArgument(), targetId);
                        }
                    });
                } else {
                    this.createQueryField(context, targetId, field);
                    QueryTransformationUtils.addFieldToQuery(context, environment, operationDefinition, field);
                }
                fields.add(field.field);
            }
            return fields;
        });
    }

    private void createQueryField(FieldTransformationContext fieldTransformationContext, Object targetId, FieldWithCounter field) {
        if (this.link.getCustomTransformation() != null) {
            this.link.getCustomTransformation().createQuery(field.field, targetId);
            return;
        }
        String variableName = this.link.getQueryArgumentName() + fieldTransformationContext.getCounter();
        field.field.setName(this.link.getTopLevelQueryField());
        field.field.setArguments(LinkTransformation.linkQueryArgumentAsList(this.link, variableName));
        fieldTransformationContext.getQueryOp().getVariableDefinitions().add(LinkTransformation.linkQueryVariableDefinition(this.link, variableName, fieldTransformationContext.getSchemaSource()));
        fieldTransformationContext.getVariables().put(variableName, targetId);
    }

    private static List<Argument> linkQueryArgumentAsList(Link link, String variableName) {
        return Collections.singletonList(new Argument(link.getQueryArgumentName(), (Value)new VariableReference(variableName)));
    }

    private static VariableDefinition linkQueryVariableDefinition(Link link, String variableName, SchemaSource schemaSource) {
        return new VariableDefinition(variableName, LinkTransformation.findArgumentType(schemaSource, link));
    }

    private static Type findArgumentType(SchemaSource schemaSource, Link link) {
        return TypeUtils.findQueryFieldDefinitions(schemaSource.getPrivateSchema()).orElseThrow(IllegalStateException::new).stream().filter(f -> f.getName().equals(link.getTopLevelQueryField())).findFirst().map(f -> f.getInputValueDefinitions().stream().filter(iv -> iv.getName().equals(link.getQueryArgumentName())).findFirst().map(InputValueDefinition::getType).orElseThrow(IllegalArgumentException::new)).orElseThrow(IllegalArgumentException::new);
    }

    private static boolean isTargetIdNullAndCannotQueryLinkWithNull(Object targetId, Link link) {
        return targetId == null && !link.isNullable();
    }

    private static boolean isOnlyTargetFieldMatchingQueryArgumentSelected(Field field, Link link) {
        List selections = field.getSelectionSet().getSelections();
        return selections.stream().allMatch(s -> s instanceof Field) && selections.stream().map(BraidObjects::cast).allMatch(f -> f.getName().equals(link.getTargetFieldMatchingQueryArgument()));
    }

    @Override
    public DataFetcherResult<Object> unapply(DataFetchingEnvironment environment, DataFetcherResult<Object> dataFetcherResult) {
        if (this.link.getCustomTransformation() != null) {
            return this.link.getCustomTransformation().unapplyForResult(environment.getField(), dataFetcherResult);
        }
        return dataFetcherResult;
    }
}

