/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.document.Fields;
import com.atlassian.braid.document.TypeMapper;
import com.atlassian.braid.document.TypeMappers;
import com.atlassian.braid.java.util.BraidLists;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

abstract class MappingContext<C> {
    private final TypeDefinitionRegistry schema;
    private final List<TypeMapper> typeMappers;
    private final List<FragmentDefinition> fragmentDefinitions;
    @Nullable
    private final C context;

    MappingContext(MappingContext<C> mappingContext) {
        this(mappingContext.context, mappingContext.schema, mappingContext.typeMappers, mappingContext.fragmentDefinitions);
    }

    MappingContext(C context, TypeDefinitionRegistry schema, List<TypeMapper> typeMappers, List<FragmentDefinition> fragmentDefinitions) {
        this.context = context;
        this.schema = Objects.requireNonNull(schema);
        this.typeMappers = Objects.requireNonNull(typeMappers);
        this.fragmentDefinitions = Objects.requireNonNull(fragmentDefinitions);
    }

    final Optional<TypeMapper> getTypeMapper() {
        return TypeMappers.maybeFindTypeMapper(this.typeMappers, this.getObjectTypeDefinition());
    }

    private Optional<FragmentDefinition> maybeGetFragmentDefinition(String name) {
        return this.fragmentDefinitions.stream().filter(fm -> fm.getName().equals(name)).findFirst();
    }

    final FragmentDefinition getFragmentDefinition(FragmentSpread fragmentSpread) {
        return this.maybeGetFragmentDefinition(fragmentSpread.getName()).orElseThrow(IllegalStateException::new);
    }

    protected List<String> getPath() {
        return Collections.emptyList();
    }

    final String getSpringPath(String targetKey) {
        return Stream.concat(this.getPath().stream(), Stream.of(targetKey)).map(p -> "['" + p + "']").collect(Collectors.joining());
    }

    boolean inList() {
        return false;
    }

    protected abstract ObjectTypeDefinition getObjectTypeDefinition();

    MappingContext forField(Field field) {
        throw new IllegalStateException();
    }

    MappingContext forInlineFragment(InlineFragment inlineFragment) {
        throw new IllegalStateException();
    }

    static <C> RootMappingContext<C> rootContext(C customContext, TypeDefinitionRegistry schema, List<TypeMapper> typeMappers) {
        return new RootMappingContext<C>(customContext, schema, typeMappers, Collections.emptyList());
    }

    public C getCustomContext() {
        return this.context;
    }

    private static class InlineFragmentMappingContext
    extends NodeMappingContext {
        private final List<String> parentPath;
        private final ObjectTypeDefinition objectTypeDefinition;

        InlineFragmentMappingContext(MappingContext parentContext, InlineFragment inlineFragment) {
            super(parentContext);
            this.parentPath = parentContext.getPath();
            this.objectTypeDefinition = parentContext.schema.getType(inlineFragment.getTypeCondition().getName()).map(ObjectTypeDefinition.class::cast).orElseThrow(IllegalStateException::new);
        }

        @Override
        protected ObjectTypeDefinition getObjectTypeDefinition() {
            return this.objectTypeDefinition;
        }

        @Override
        protected List<String> getPath() {
            return this.parentPath;
        }

        @Override
        boolean inList() {
            return false;
        }
    }

    private static class FieldMappingContext
    extends NodeMappingContext {
        private final Field field;
        private final List<String> parentPath;
        private final TypeInfo typeInfo;
        private final ObjectTypeDefinition objectTypeDefinition;

        FieldMappingContext(MappingContext parentContext, Field field) {
            super(parentContext);
            this.field = Objects.requireNonNull(field);
            this.parentPath = parentContext.getPath();
            this.typeInfo = Fields.maybeGetTypeInfo(parentContext.getObjectTypeDefinition(), field).orElseThrow(IllegalStateException::new);
            this.objectTypeDefinition = Fields.maybeFindObjectTypeDefinition(parentContext.schema, this.typeInfo).orElseThrow(IllegalStateException::new);
        }

        @Override
        protected ObjectTypeDefinition getObjectTypeDefinition() {
            return this.objectTypeDefinition;
        }

        @Override
        protected List<String> getPath() {
            return this.inList() ? Collections.emptyList() : BraidLists.concat(this.parentPath, Fields.getFieldAliasOrName(this.field));
        }

        @Override
        boolean inList() {
            return this.typeInfo.isList();
        }
    }

    static class OperationDefinitionMappingContext
    extends NodeMappingContext {
        private final ObjectTypeDefinition objectTypeDefinition;

        OperationDefinitionMappingContext(MappingContext parentContext, OperationDefinition operationDefinition) {
            super(parentContext);
            this.objectTypeDefinition = OperationDefinitionMappingContext.findOperationTypeDefinition(parentContext.schema, operationDefinition);
        }

        @Override
        public ObjectTypeDefinition getObjectTypeDefinition() {
            return this.objectTypeDefinition;
        }

        private static ObjectTypeDefinition findOperationTypeDefinition(TypeDefinitionRegistry schema, OperationDefinition op) {
            if (op.getOperation() == OperationDefinition.Operation.QUERY) {
                return TypeUtils.findQueryType(schema).get();
            }
            if (op.getOperation() == OperationDefinition.Operation.MUTATION) {
                return TypeUtils.findMutationType(schema).get();
            }
            throw new IllegalStateException("Unexpected operation type" + op.getOperation());
        }

        private static Function<List<OperationTypeDefinition>, Optional<OperationTypeDefinition>> maybeFindOperationTypeDefinition(OperationDefinition op) {
            return ops -> ops.stream().filter(OperationDefinitionMappingContext.isOperationTypeDefinitionForOperationType(op)).findFirst();
        }

        private static Predicate<OperationTypeDefinition> isOperationTypeDefinitionForOperationType(OperationDefinition op) {
            return otd -> otd.getName().equalsIgnoreCase(op.getOperation().name());
        }
    }

    static abstract class NodeMappingContext<C>
    extends MappingContext<C> {
        NodeMappingContext(MappingContext<C> parentContext) {
            super(parentContext);
        }

        @Override
        NodeMappingContext forField(Field field) {
            return new FieldMappingContext(this, field);
        }

        @Override
        MappingContext forInlineFragment(InlineFragment inlineFragment) {
            return new InlineFragmentMappingContext(this, inlineFragment);
        }
    }

    static final class FragmentDefinitionMappingContext<C>
    extends NodeMappingContext<C> {
        private final ObjectTypeDefinition objectTypeDefinition;

        FragmentDefinitionMappingContext(MappingContext<C> parentContext, FragmentDefinition definition) {
            super(parentContext);
            this.objectTypeDefinition = FragmentDefinitionMappingContext.findFragmentObjectTypeDefinition(((MappingContext)parentContext).schema, definition);
        }

        @Override
        public ObjectTypeDefinition getObjectTypeDefinition() {
            return this.objectTypeDefinition;
        }

        private static ObjectTypeDefinition findFragmentObjectTypeDefinition(TypeDefinitionRegistry schema, FragmentDefinition definition) {
            return schema.getType(definition.getTypeCondition().getName()).map(ObjectTypeDefinition.class::cast).orElseThrow(IllegalStateException::new);
        }
    }

    static final class RootMappingContext<C>
    extends MappingContext<C> {
        RootMappingContext(MappingContext<C> parentContext, List<FragmentDefinition> fragmentMappings) {
            this(((MappingContext)parentContext).context, ((MappingContext)parentContext).schema, ((MappingContext)parentContext).typeMappers, fragmentMappings);
        }

        RootMappingContext(C customContext, TypeDefinitionRegistry schema, List<TypeMapper> typeMappers, List<FragmentDefinition> fragmentMappings) {
            super(customContext, schema, typeMappers, fragmentMappings);
        }

        FragmentDefinitionMappingContext<C> forFragment(FragmentDefinition definition) {
            return new FragmentDefinitionMappingContext(this, definition);
        }

        OperationDefinitionMappingContext forOperationDefinition(OperationDefinition definition) {
            return new OperationDefinitionMappingContext(this, definition);
        }

        RootMappingContext withFragments(List<FragmentDefinition> fragmentMappings) {
            return new RootMappingContext<C>(this, fragmentMappings);
        }

        @Override
        protected ObjectTypeDefinition getObjectTypeDefinition() {
            throw new IllegalStateException();
        }
    }
}

