/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.transformation.BraidSchemaSource;
import graphql.analysis.QueryTraversal;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.SelectionSet;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TrimFieldsSelection {
    public static List<FragmentDefinition> trimFieldSelection(final SchemaSource schemaSource, DataFetchingEnvironment environment, Node root, final boolean ignoreFirstField) {
        final ArrayList<FieldWithLink> clearSubSelectionAndRenameField = new ArrayList<FieldWithLink>();
        final ArrayList clearSubSelection = new ArrayList();
        final LinkedHashMap<Field, SelectionSet> parentSelectionSets = new LinkedHashMap<Field, SelectionSet>();
        final BraidSchemaSource braidSchemaSource = new BraidSchemaSource(schemaSource);
        QueryVisitorStub nodeVisitor = new QueryVisitorStub(){

            public void visitField(QueryVisitorFieldEnvironment env) {
                boolean isFirstField;
                if (env.isTypeNameIntrospectionField()) {
                    return;
                }
                GraphQLFieldsContainer parentFieldsContainer = env.getFieldsContainer();
                Field field = env.getField();
                boolean bl = isFirstField = env.getParentEnvironment() == null;
                if (isFirstField && ignoreFirstField) {
                    return;
                }
                Optional linkWithSeparateInputField = TrimFieldsSelection.getLinkWithSeparateInputField(braidSchemaSource, schemaSource.getLinks(), parentFieldsContainer.getName(), field.getName());
                Optional linkWithFieldUsedAsInput = TrimFieldsSelection.getLinkWithFieldUsedAsInput(schemaSource.getLinks(), parentFieldsContainer.getName(), field.getName());
                linkWithSeparateInputField.ifPresent(link -> {
                    clearSubSelectionAndRenameField.add(new FieldWithLink(field, (Link)link));
                    if (env.getParentEnvironment() == null) {
                        return;
                    }
                    parentSelectionSets.put(field, env.getParentEnvironment().getField().getSelectionSet());
                    env.getParentEnvironment().getField().getSelectionSet();
                });
                linkWithFieldUsedAsInput.ifPresent(link -> clearSubSelection.add(new FieldWithLink(field, (Link)link)));
            }
        };
        Map<String, FragmentDefinition> fragmentsByName = environment.getFragmentsByName().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FragmentDefinition)entry.getValue()).deepCopy()));
        QueryTraversal queryTraversal = QueryTraversal.newQueryTraversal().schema(environment.getGraphQLSchema()).root(root).rootParentType((GraphQLObjectType)environment.getParentType()).fragmentsByName(fragmentsByName).variables(environment.getExecutionContext().getVariables()).build();
        queryTraversal.visitPreOrder((QueryVisitor)nodeVisitor);
        TrimFieldsSelection.removeDuplicationsCausedByInputFields(clearSubSelectionAndRenameField, parentSelectionSets);
        clearSubSelection.forEach(fieldWithLink -> fieldWithLink.field.setSelectionSet(null));
        clearSubSelectionAndRenameField.forEach(fieldWithLink -> {
            fieldWithLink.field.setSelectionSet(null);
            fieldWithLink.field.setName(fieldWithLink.link.getSourceInputFieldName());
        });
        LinkedHashSet<FragmentDefinition> referencedFragments = new LinkedHashSet<FragmentDefinition>();
        TrimFieldsSelection.getReferencedFragments(root, fragmentsByName, referencedFragments);
        return new ArrayList<FragmentDefinition>(referencedFragments);
    }

    private static void removeDuplicationsCausedByInputFields(List<FieldWithLink> clearSubSelectionAndRenameField, Map<Field, SelectionSet> parentSelectionSets) {
        LinkedHashMap<SelectionSet, List> fieldsToRemove = new LinkedHashMap<SelectionSet, List>();
        for (FieldWithLink fieldWithLink : clearSubSelectionAndRenameField) {
            String currentFieldAlias;
            String sourceInputFieldName;
            SelectionSet selectionSet2 = parentSelectionSets.get(fieldWithLink.field);
            if (selectionSet2 == null || !TrimFieldsSelection.selectionSetContainsField(selectionSet2, sourceInputFieldName = fieldWithLink.link.getSourceInputFieldName(), currentFieldAlias = fieldWithLink.field.getAlias())) continue;
            fieldsToRemove.computeIfAbsent(selectionSet2, notUsed -> new ArrayList());
            ((List)fieldsToRemove.get(selectionSet2)).add(fieldWithLink.field);
        }
        fieldsToRemove.forEach((selectionSet, fields) -> selectionSet.getSelections().removeAll((Collection<?>)fields));
    }

    private static boolean selectionSetContainsField(SelectionSet selectionSet, String name, String alias) {
        return selectionSet.getSelections().stream().filter(selection -> selection instanceof Field).map(field -> (Field)field).anyMatch(field -> field.getName().equals(name) && Objects.equals(field.getAlias(), alias));
    }

    private static void getReferencedFragments(Node root, final Map<String, FragmentDefinition> fragmentDefinitionMap, Set<FragmentDefinition> referencedFragments) {
        final LinkedHashSet childFragments = new LinkedHashSet();
        NodeVisitorStub nodeVisitorStub = new NodeVisitorStub(){

            public TraversalControl visitFragmentSpread(FragmentSpread fragmentSpread, TraverserContext<Node> context) {
                childFragments.add(fragmentDefinitionMap.get(fragmentSpread.getName()));
                return TraversalControl.CONTINUE;
            }
        };
        new NodeTraverser().preOrder((NodeVisitor)nodeVisitorStub, root);
        childFragments.stream().filter(referencedFragments::add).forEach(frag -> TrimFieldsSelection.getReferencedFragments((Node)frag, fragmentDefinitionMap, referencedFragments));
    }

    private static Optional<Link> getLinkWithSeparateInputField(BraidSchemaSource braidSchemaSource, Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> braidSchemaSource.getLinkBraidSourceType((Link)l).equals(typeName) && l.getNewFieldName().equals(fieldName) && !l.getSourceInputFieldName().equals(fieldName)).findFirst();
    }

    private static Optional<Link> getLinkWithFieldUsedAsInput(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName)).filter(l -> l.getSourceInputFieldName().equals(fieldName)).findFirst();
    }

    private static class FieldWithLink {
        public Field field;
        public Link link;

        public FieldWithLink(Field field, Link link) {
            this.field = field;
            this.link = link;
        }
    }
}

