/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.MutableBraidContext;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.dataloader.DataLoaderRegistry;

public class BraidGraphQL {
    private final DataLoaderRegistry dlr;
    private final Function<DataLoaderRegistry, GraphQL> graphQLFactory;

    BraidGraphQL(Supplier<DataLoaderRegistry> dlr, Function<DataLoaderRegistry, GraphQL> graphQLFactory) {
        this.dlr = Objects.requireNonNull(dlr.get());
        this.graphQLFactory = Objects.requireNonNull(graphQLFactory);
    }

    @Nonnull
    public CompletableFuture<ExecutionResult> execute(ExecutionInput executionInput) {
        GraphQL graphQL = this.graphQLFactory.apply(this.dlr);
        ExecutionInput newInput = executionInput.transform(builder -> builder.context(new MutableBraidContext<Object>(this.dlr, executionInput.getContext())));
        return graphQL.executeAsync(newInput);
    }
}

