/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.FieldAlias;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.transformation.BraidSchemaSource;
import com.atlassian.braid.transformation.BraidingContext;
import com.atlassian.braid.transformation.DataFetcherUtils;
import com.atlassian.braid.transformation.SchemaTransformation;
import com.atlassian.braid.transformation.TopLevelFieldTransformation;
import graphql.execution.DataFetcherResult;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;

public class TopLevelSchemaTransformation
implements SchemaTransformation {
    @Override
    public Map<String, BatchLoader> transform(BraidingContext braidingContext) {
        Map<SchemaNamespace, BraidSchemaSource> dataSources = braidingContext.getDataSources();
        List<FieldDataLoaderRegistration> queryLoaders = TopLevelSchemaTransformation.addSchemaSourcesTopLevelFieldsToOperation(dataSources, braidingContext.getQueryObjectTypeDefinition(), BraidSchemaSource::getQueryType, BraidSchemaSource::getQueryFieldAlias);
        List<FieldDataLoaderRegistration> mutationLoaders = TopLevelSchemaTransformation.addSchemaSourcesTopLevelFieldsToOperation(dataSources, braidingContext.getMutationObjectTypeDefinition(), BraidSchemaSource::getMutationType, BraidSchemaSource::getMutationFieldAliases);
        return Stream.of(queryLoaders, mutationLoaders).flatMap(Collection::stream).map(r -> {
            String dataLoaderKey = DataFetcherUtils.getDataLoaderKey(((FieldDataLoaderRegistration)r).type, ((FieldDataLoaderRegistration)r).field);
            braidingContext.getRuntimeWiringBuilder().type(((FieldDataLoaderRegistration)r).type, wiring -> wiring.dataFetcher(((FieldDataLoaderRegistration)r).field, (DataFetcher)new TopLevelDataFetcher(((FieldDataLoaderRegistration)r).type, ((FieldDataLoaderRegistration)r).field)));
            return Collections.singletonMap(dataLoaderKey, ((FieldDataLoaderRegistration)r).loader);
        }).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static List<FieldDataLoaderRegistration> addSchemaSourcesTopLevelFieldsToOperation(Map<SchemaNamespace, BraidSchemaSource> dataSources, ObjectTypeDefinition braidOperationType, Function<BraidSchemaSource, Optional<ObjectTypeDefinition>> findOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldAlias>> getFieldAlias) {
        return dataSources.values().stream().map(source -> TopLevelSchemaTransformation.addSchemaSourceTopLevelFieldsToOperation(source, braidOperationType, findOperationType, getFieldAlias)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<FieldDataLoaderRegistration> addSchemaSourceTopLevelFieldsToOperation(BraidSchemaSource source, ObjectTypeDefinition braidOperationType, Function<BraidSchemaSource, Optional<ObjectTypeDefinition>> findOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldAlias>> getFieldAlias) {
        return findOperationType.apply(source).map(operationType -> TopLevelSchemaTransformation.addSchemaSourceTopLevelFieldsToOperation(source, braidOperationType, operationType, getFieldAlias)).orElse(Collections.emptyList());
    }

    private static List<FieldDataLoaderRegistration> addSchemaSourceTopLevelFieldsToOperation(BraidSchemaSource schemaSource, ObjectTypeDefinition braidOperationType, ObjectTypeDefinition sourceOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldAlias>> getFieldAlias) {
        List<BraidFieldDefinition> fieldDefinitions = TopLevelSchemaTransformation.aliasedFieldDefinitions(schemaSource, sourceOperationType, getFieldAlias);
        List braidOperationTypeFieldDefinitions = braidOperationType.getFieldDefinitions();
        fieldDefinitions.forEach(bfd -> braidOperationTypeFieldDefinitions.add(((BraidFieldDefinition)bfd).definition));
        return TopLevelSchemaTransformation.wireOperationFields(braidOperationType.getName(), schemaSource, fieldDefinitions);
    }

    private static List<BraidFieldDefinition> aliasedFieldDefinitions(BraidSchemaSource schemaSource, ObjectTypeDefinition sourceOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldAlias>> getFieldAlias) {
        return sourceOperationType.getFieldDefinitions().stream().map(definition -> ((Optional)getFieldAlias.apply(schemaSource, definition.getName())).map(alias -> new BraidFieldDefinition((FieldAlias)alias, (FieldDefinition)definition))).filter(Optional::isPresent).map(Optional::get).map(def -> TopLevelSchemaTransformation.aliasedFieldDefinition(schemaSource, def)).collect(Collectors.toList());
    }

    private static BraidFieldDefinition aliasedFieldDefinition(BraidSchemaSource schemaSource, BraidFieldDefinition braidFieldDefinition) {
        FieldDefinition definition = braidFieldDefinition.definition;
        Type aliasedType = schemaSource.aliasType(definition.getType());
        return new BraidFieldDefinition(braidFieldDefinition.alias, FieldDefinition.newFieldDefinition().name(braidFieldDefinition.alias.getBraidName()).type(aliasedType).inputValueDefinitions(schemaSource.aliasInputValueDefinitions(definition.getInputValueDefinitions())).directives(definition.getDirectives()).build());
    }

    private static List<FieldDataLoaderRegistration> wireOperationFields(String typeName, BraidSchemaSource schemaSource, List<BraidFieldDefinition> fieldDefinitions) {
        return fieldDefinitions.stream().map(queryField -> TopLevelSchemaTransformation.wireOperationField(typeName, schemaSource, queryField)).collect(Collectors.toList());
    }

    private static FieldDataLoaderRegistration wireOperationField(String typeName, BraidSchemaSource schemaSource, BraidFieldDefinition operationField) {
        BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> batchLoader = schemaSource.getSchemaSource().newBatchLoader(schemaSource.getSchemaSource(), new TopLevelFieldTransformation(operationField.alias));
        return new FieldDataLoaderRegistration(typeName, operationField.alias.getBraidName(), batchLoader);
    }

    private static class TopLevelDataFetcher
    implements DataFetcher {
        private final String type;
        private final String field;

        TopLevelDataFetcher(String type, String field) {
            this.type = type;
            this.field = field;
        }

        public Object get(DataFetchingEnvironment env) {
            DataLoaderRegistry registry = TopLevelDataFetcher.getDataLoaderRegistry(env);
            CompletableFuture loadedValue = registry.getDataLoader(DataFetcherUtils.getDataLoaderKey(this.type, this.field)).load((Object)env);
            return Optional.ofNullable(registry.getDataLoader(DataFetcherUtils.getLinkDataLoaderKey(this.type, this.field))).map(l -> TopLevelDataFetcher.loadFromLinkLoader(env, loadedValue, (DataLoader<Object, Object>)l)).orElse(loadedValue);
        }

        private static Object loadFromLinkLoader(DataFetchingEnvironment env, Object source, DataLoader<Object, Object> dataLoader) {
            return dataLoader.load((Object)DataFetchingEnvironmentBuilder.newDataFetchingEnvironment((DataFetchingEnvironment)env).source(source).fieldDefinition(env.getFieldDefinition()).build());
        }

        static DataLoaderRegistry getDataLoaderRegistry(DataFetchingEnvironment env) {
            return TopLevelDataFetcher.getContext(env).getDataLoaderRegistry();
        }

        static BraidContext getContext(DataFetchingEnvironment env) {
            return (BraidContext)env.getContext();
        }
    }

    private static class FieldDataLoaderRegistration {
        private final String type;
        private final String field;
        private final BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> loader;

        private FieldDataLoaderRegistration(String type, String field, BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> loader) {
            this.type = Objects.requireNonNull(type);
            this.field = Objects.requireNonNull(field);
            this.loader = Objects.requireNonNull(loader);
        }
    }

    private static final class BraidFieldDefinition {
        private final FieldAlias alias;
        private final FieldDefinition definition;

        private BraidFieldDefinition(FieldAlias alias, FieldDefinition definition) {
            this.alias = alias;
            this.definition = definition;
        }
    }
}

