package com.atlassian.braid.transformation;

import com.atlassian.braid.FieldAlias;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.FieldTransformationContext;
import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import static com.atlassian.braid.transformation.QueryTransformationUtils.addFieldToQuery;
import static com.atlassian.braid.transformation.QueryTransformationUtils.cloneField;
import static com.atlassian.braid.transformation.QueryTransformationUtils.getOperationDefinition;
import static java.util.Collections.singletonList;
import static java.util.concurrent.CompletableFuture.completedFuture;


/**
 * A mutation that will fetch the top level field from a remote source, optionally changing the name of the field
 */
public class TopLevelFieldTransformation implements FieldTransformation {

    private final FieldAlias alias;

    TopLevelFieldTransformation(FieldAlias alias) {
        this.alias = alias;
    }

    @Override
    public CompletableFuture<List<Field>> apply(DataFetchingEnvironment environment, FieldTransformationContext context) {
        FieldWithCounter field = cloneField(context, new ArrayList<>(), environment);

        if (alias.getBraidName().equals(field.field.getName()) && !alias.getSourceName().equals(field.field.getName())) {
            field.field.setName(alias.getSourceName());
        }
        addFieldToQuery(context, environment, getOperationDefinition(environment), field);

        return completedFuture(singletonList(field.field));
    }
}
