/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.FieldKey;
import com.atlassian.braid.source.QueryExecutorSchemaSource;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class FieldMutationContext {
    private final Map<String, Object> variables;
    private final Map<DataFetchingEnvironment, List<FieldKey>> clonedFields;
    private final AtomicInteger counter;
    private final Map<FieldKey, Object> shortCircuitedData;
    private final Document document;
    private final QueryExecutorSchemaSource schemaSource;
    private final OperationDefinition queryOp;
    private final List<Field> missingFields = new ArrayList<Field>();

    public FieldMutationContext(QueryExecutorSchemaSource schemaSource, OperationDefinition queryOp) {
        this.schemaSource = schemaSource;
        this.queryOp = queryOp;
        this.document = Document.newDocument().build();
        this.document.getDefinitions().add(queryOp);
        this.variables = new HashMap<String, Object>();
        this.clonedFields = new HashMap<DataFetchingEnvironment, List<FieldKey>>();
        this.counter = new AtomicInteger(99);
        this.shortCircuitedData = new HashMap<FieldKey, Object>();
    }

    public OperationDefinition getQueryOp() {
        return this.queryOp;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Document getDocument() {
        return this.document;
    }

    public Map<DataFetchingEnvironment, List<FieldKey>> getClonedFields() {
        return this.clonedFields;
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public QueryExecutorSchemaSource getSchemaSource() {
        return this.schemaSource;
    }

    public List<Field> getMissingFields() {
        return this.missingFields;
    }

    public Map<FieldKey, Object> getShortCircuitedData() {
        return this.shortCircuitedData;
    }

    public void addMissingFields(List<Field> missingFields) {
        this.missingFields.clear();
        this.missingFields.addAll(missingFields);
    }
}

