/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.graphql.language.AliasablePropertyDataFetcher;
import com.atlassian.braid.java.util.BraidCollectors;
import com.atlassian.braid.mutation.BraidSchemaSource;
import com.atlassian.braid.mutation.BraidTypeDefinition;
import com.atlassian.braid.mutation.BraidingContext;
import com.atlassian.braid.mutation.ExtensionMutationInjector;
import com.atlassian.braid.mutation.FieldMutationInjector;
import com.atlassian.braid.mutation.LinkMutationInjector;
import com.atlassian.braid.mutation.TopLevelFieldMutationInjector;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;

final class BraidSchema {
    private final GraphQLSchema schema;
    private final Map<String, BatchLoader> batchLoaders;
    private static final List<FieldMutationInjector> fieldMutationFactories = Arrays.asList(new LinkMutationInjector(), new TopLevelFieldMutationInjector(), new ExtensionMutationInjector());

    private BraidSchema(GraphQLSchema schema, Map<String, BatchLoader> batchLoaders) {
        this.schema = Objects.requireNonNull(schema);
        this.batchLoaders = Objects.requireNonNull(batchLoaders);
    }

    static BraidSchema from(TypeDefinitionRegistry typeDefinitionRegistry, RuntimeWiring.Builder runtimeWiringBuilder, List<SchemaSource> schemaSources) {
        Map<SchemaNamespace, BraidSchemaSource> dataSourceTypes = BraidSchema.toBraidSchemaSourceMap(schemaSources);
        BraidSchema.findSchemaDefinitionOrCreateOne(typeDefinitionRegistry);
        ObjectTypeDefinition queryObjectTypeDefinition = TypeUtils.findQueryType(typeDefinitionRegistry).orElseGet(() -> TypeUtils.addQueryTypeToSchema(typeDefinitionRegistry, TypeUtils.createDefaultQueryTypeDefinition()));
        ObjectTypeDefinition mutationObjectTypeDefinition = TypeUtils.findMutationType(typeDefinitionRegistry).orElseGet(TypeUtils::createDefaultMutationTypeDefinition);
        Map<String, BatchLoader> batchLoaders = BraidSchema.addDataSources(dataSourceTypes, typeDefinitionRegistry, runtimeWiringBuilder, queryObjectTypeDefinition, mutationObjectTypeDefinition);
        if (!mutationObjectTypeDefinition.getFieldDefinitions().isEmpty()) {
            TypeUtils.addMutationTypeToSchema(typeDefinitionRegistry, mutationObjectTypeDefinition);
        }
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(typeDefinitionRegistry, runtimeWiringBuilder.build());
        return new BraidSchema(graphQLSchema, batchLoaders);
    }

    private static void findSchemaDefinitionOrCreateOne(TypeDefinitionRegistry typeDefinitionRegistry) {
        typeDefinitionRegistry.schemaDefinition().orElseGet(() -> BraidSchema.createDefaultSchemaDefinition(typeDefinitionRegistry));
    }

    private static SchemaDefinition createDefaultSchemaDefinition(TypeDefinitionRegistry typeDefinitionRegistry) {
        SchemaDefinition.Builder builder = SchemaDefinition.newSchemaDefinition();
        typeDefinitionRegistry.getType("Query").ifPresent(__ -> BraidSchema.addOperation(builder, "query", "Query"));
        typeDefinitionRegistry.getType("Mutation").ifPresent(__ -> BraidSchema.addOperation(builder, "mutation", "Mutation"));
        SchemaDefinition schemaDefinition = builder.build();
        typeDefinitionRegistry.add((SDLDefinition)schemaDefinition);
        return schemaDefinition;
    }

    private static void addOperation(SchemaDefinition.Builder schemaDefinition, String queryFieldName, String defaultQueryTypeName) {
        schemaDefinition.operationTypeDefinition(new OperationTypeDefinition(queryFieldName, (Type)new TypeName(defaultQueryTypeName)));
    }

    private static Map<String, BatchLoader> addDataSources(Map<SchemaNamespace, BraidSchemaSource> dataSources, TypeDefinitionRegistry registry, RuntimeWiring.Builder runtimeWiringBuilder, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition) {
        BraidSchema.addAllNonOperationTypes(dataSources, registry, runtimeWiringBuilder);
        BraidingContext braidingContext = new BraidingContext(dataSources, registry, runtimeWiringBuilder, queryObjectTypeDefinition, mutationObjectTypeDefinition);
        return fieldMutationFactories.stream().map(m -> m.inject(braidingContext)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    Map<String, BatchLoader> getBatchLoaders() {
        return Collections.unmodifiableMap(this.batchLoaders);
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    private static void addAllNonOperationTypes(Map<SchemaNamespace, BraidSchemaSource> dataSources, TypeDefinitionRegistry registry, RuntimeWiring.Builder runtimeWiringBuilder) {
        Map<String, List<BraidTypeDefinition>> allNonOperationTypeDefinitions = dataSources.values().stream().map(BraidSchemaSource::getNonOperationTypes).flatMap(Collection::stream).collect(Collectors.groupingBy(BraidTypeDefinition::getName));
        List duplicateTypes = allNonOperationTypeDefinitions.values().stream().filter(e -> e.size() > 1).collect(Collectors.toList());
        if (!duplicateTypes.isEmpty()) {
            duplicateTypes.stream().flatMap(Collection::stream).forEach(c -> System.out.printf("Type `%s` from %s is in conflict\n", c.getName(), c.getNamespace()));
            throw new IllegalStateException("Type name conflict exists");
        }
        allNonOperationTypeDefinitions.values().stream().map(types -> (BraidTypeDefinition)types.get(0)).peek(type -> BraidSchema.wireFieldDefinitions(runtimeWiringBuilder, type.getType(), type.getFieldDefinitions())).map(BraidTypeDefinition::getType).forEach(arg_0 -> ((TypeDefinitionRegistry)registry).add(arg_0));
    }

    private static void wireFieldDefinitions(RuntimeWiring.Builder runtimeWiringBuilder, TypeDefinition type, List<FieldDefinition> fieldDefinitions) {
        fieldDefinitions.forEach(fd -> runtimeWiringBuilder.type(type.getName(), wiring -> wiring.dataFetcher(fd.getName(), (DataFetcher)new AliasablePropertyDataFetcher(fd.getName()))));
    }

    private static Map<SchemaNamespace, BraidSchemaSource> toBraidSchemaSourceMap(List<SchemaSource> schemaSources) {
        return schemaSources.stream().map(BraidSchemaSource::new).collect(Collectors.groupingBy(BraidSchemaSource::getNamespace, BraidCollectors.singleton()));
    }
}

