/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source.yaml;

import com.atlassian.braid.FieldAlias;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.Mappers;
import com.atlassian.braid.source.GraphQLRemoteRetriever;
import com.atlassian.braid.source.GraphQLRemoteSchemaSource;
import com.atlassian.braid.source.yaml.RestRemoteRetriever;
import com.atlassian.braid.source.yaml.RestRemoteSchemaSource;
import com.atlassian.braid.source.yaml.YamlRemoteSchemaSourceBuilder;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class YamlRemoteSchemaSourceFactory {
    public static <C> RestRemoteSchemaSource<C> createRestSource(Reader source, RestRemoteRetriever<C> restRemoteRetriever) {
        Map<String, Object> m = YamlRemoteSchemaSourceFactory.loadYamlMap(source);
        SchemaNamespace namespace = YamlRemoteSchemaSourceBuilder.buildSchemaNamespace(m);
        Supplier<Reader> schema = YamlRemoteSchemaSourceBuilder.buildSchemaProvider(m);
        Map<String, RestRemoteSchemaSource.RootField> rootFields = BraidMaps.get(m, "rootFields").map(BraidObjects::cast).orElse(Collections.emptyMap()).entrySet().stream().map(e -> {
            String fieldName = (String)e.getKey();
            Map params = (Map)e.getValue();
            Mapper mapping = Mappers.fromYamlList((List)BraidObjects.cast(params.get("responseMapping")));
            return new RestRemoteSchemaSource.RootField(fieldName, (String)BraidObjects.cast(params.get("uri")), mapping);
        }).collect(Collectors.toMap(f -> f.name, f -> f));
        return new RestRemoteSchemaSource<C>(namespace, schema, restRemoteRetriever, rootFields, YamlRemoteSchemaSourceBuilder.buildLinks(m), (String[])YamlRemoteSchemaSourceBuilder.buildQueryAliases(m).stream().map(FieldAlias::getSourceName).toArray(String[]::new));
    }

    public static <C> SchemaSource createGraphQLSource(Reader source, GraphQLRemoteRetriever<C> graphQLRemoteRetriever) {
        Map<String, Object> m = YamlRemoteSchemaSourceFactory.loadYamlMap(source);
        return GraphQLRemoteSchemaSource.builder().namespace(YamlRemoteSchemaSourceBuilder.buildSchemaNamespace(m)).schemaProvider(YamlRemoteSchemaSourceBuilder.buildSchemaProvider(m)).remoteRetriever(graphQLRemoteRetriever).links(YamlRemoteSchemaSourceBuilder.buildLinks(m)).queryFieldAliases(YamlRemoteSchemaSourceBuilder.buildQueryAliases(m)).mutationFieldAliases(YamlRemoteSchemaSourceBuilder.buildMutationAliases(m)).typeAliases(YamlRemoteSchemaSourceBuilder.buildTypeAliases(m)).documentMapperFactory(YamlRemoteSchemaSourceBuilder.buildDocumentMapperFactory(m)).build();
    }

    private static Map<String, Object> loadYamlMap(Reader source) {
        return (Map)BraidObjects.cast(new Yaml().load(source));
    }
}

