/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.mapper.CopyListOperation;
import com.atlassian.braid.mapper.CopyMapOperation;
import com.atlassian.braid.mapper.CopyOperation;
import com.atlassian.braid.mapper.ListOperation;
import com.atlassian.braid.mapper.MapOperation;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.MapperException;
import com.atlassian.braid.mapper.MapperOperation;
import com.atlassian.braid.mapper.Mappers;
import com.atlassian.braid.mapper.PutOperation;
import com.atlassian.braid.yaml.BraidYaml;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class YamlMappers {
    YamlMappers() {
    }

    static List<MapperOperation> toMapperOperations(List<Map<String, Object>> yamlAsList) {
        return yamlAsList.stream().map(YamlMappers::toYamlOperation).map(YamlMapperOperation::get).collect(Collectors.toList());
    }

    private static YamlMapperOperation toYamlOperation(Map<String, Object> yaml) {
        if (yaml.size() == 1) {
            Map.Entry<String, Object> operationAsEntry = BraidMaps.firstEntry(yaml);
            assert (operationAsEntry != null);
            return new YamlMapperOperation(operationAsEntry.getKey(), (String)BraidObjects.cast(operationAsEntry.getValue()), Collections.emptyMap());
        }
        return new YamlMapperOperation(BraidYaml.getKey(yaml, MapperException::new), BraidYaml.getOperationName(yaml, MapperException::new), yaml);
    }

    private static Mapper getMapper(Map<String, Object> props) {
        return BraidYaml.getMapper(props).map(Mappers::fromYamlList).orElseGet(Mappers::mapper);
    }

    private static class YamlMapperOperation
    implements Supplier<MapperOperation> {
        private final String key;
        private final String name;
        private final Map<String, Object> props;

        private YamlMapperOperation(String key, String name, Map<String, Object> props) {
            this.key = Objects.requireNonNull(key);
            this.name = Objects.requireNonNull(name);
            this.props = Objects.requireNonNull(props);
        }

        private YamlOperationType getOperation() {
            try {
                return YamlOperationType.valueOf(this.name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new MapperException("Could not find operation with name '%s'", this.name);
            }
        }

        @Override
        public MapperOperation get() {
            return this.getOperation().apply(this.key, this.props);
        }
    }

    static enum YamlOperationType implements BiFunction<String, Map<String, Object>, MapperOperation>
    {
        COPY((key, props) -> new CopyOperation((String)key, BraidYaml.getTargetKey(props, key), () -> null, Function.identity())),
        PUT((key, props) -> new PutOperation((String)key, props.get("value"))),
        COPYLIST((key, props) -> new CopyListOperation((String)key, BraidYaml.getTargetKey(props, key), YamlMappers.getMapper(props))),
        LIST((key, props) -> new ListOperation((String)key, __ -> true, YamlMappers.getMapper(props))),
        MAP((key, props) -> new MapOperation((String)key, __ -> true, YamlMappers.getMapper(props))),
        COPYMAP((key, props) -> new CopyMapOperation((String)key, BraidYaml.getTargetKey(props, key), YamlMappers.getMapper(props)));

        final BiFunction<String, Map<String, Object>, MapperOperation> getOperation;

        private YamlOperationType(BiFunction<String, Map<String, Object>, MapperOperation> getOperation) {
            this.getOperation = getOperation;
        }

        @Override
        public MapperOperation apply(String key, Map<String, Object> props) {
            return this.getOperation.apply(key, props);
        }
    }
}

