/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.CopyListOperation;
import com.atlassian.braid.mapper.CopyOperation;
import com.atlassian.braid.mapper.MapOperation;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.MapperOperation;
import com.atlassian.braid.mapper.PutOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class MapperOperations {
    private MapperOperations() {
    }

    public static MapperOperation noop() {
        return new NoopOperation();
    }

    public static MapperOperation composed(MapperOperation ... operations) {
        return MapperOperations.composed(Arrays.asList(operations));
    }

    public static MapperOperation composed(List<MapperOperation> operations) {
        return new ComposedOperation(operations);
    }

    public static MapperOperation map(String key, Mapper mapper) {
        return new MapOperation(key, __ -> true, mapper);
    }

    public static <T> MapperOperation copy(String sourceKey, String targetKey) {
        return new CopyOperation(sourceKey, targetKey, () -> null, Function.identity());
    }

    public static <T> MapperOperation copyList(String key, Mapper mapper) {
        return new CopyListOperation(key, key, mapper);
    }

    public static MapperOperation put(String key, String value) {
        return new PutOperation<String>(key, value);
    }

    private static class ComposedOperation
    implements MapperOperation {
        private final List<MapperOperation> operations;

        private ComposedOperation(List<MapperOperation> operations) {
            this.operations = new ArrayList<MapperOperation>(operations);
        }

        @Override
        public void accept(Map<String, Object> input, Map<String, Object> output) {
            this.operations.forEach(op -> op.accept(input, output));
        }
    }

    private static class NoopOperation
    implements MapperOperation {
        private NoopOperation() {
        }

        @Override
        public void accept(Map<String, Object> input, Map<String, Object> output) {
        }
    }
}

