/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.java.util.BraidPreconditions;
import com.atlassian.braid.mapper.MapperInputOutput;
import com.atlassian.braid.mapper.MapperInputOutputPair;
import com.atlassian.braid.mapper.MapperMaps;
import com.atlassian.braid.mapper.MapperOperation;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

final class MapOperation
implements MapperOperation {
    private final String key;
    private final Function<Map<String, Object>, Map<String, Object>> mapper;
    private final Predicate<MapperInputOutput> predicate;

    MapOperation(String key, Predicate<MapperInputOutput> predicate, Function<Map<String, Object>, Map<String, Object>> mapper) {
        this.key = Objects.requireNonNull(key);
        this.predicate = Objects.requireNonNull(predicate);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public void accept(Map<String, Object> input, Map<String, Object> output) {
        if (this.predicate.test(MapperInputOutputPair.of(input, output))) {
            output.put(this.key, MapperMaps.mergeMaps(MapOperation.getExistingMapValue(output, this.key), this.mapper.apply(input)));
        }
    }

    private static Map<String, Object> getExistingMapValue(Map<String, Object> map, String key) {
        Object existingValue = map.get(key);
        if (existingValue != null) {
            BraidPreconditions.checkState(existingValue instanceof Map);
            return (Map)BraidObjects.cast(existingValue);
        }
        return Collections.emptyMap();
    }
}

