/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.MapperInputOutput;
import com.atlassian.braid.mapper.MapperInputOutputPair;
import com.atlassian.braid.mapper.MapperOperation;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

final class ListOperation
implements MapperOperation {
    private final String key;
    private final Mapper mapper;
    private final Predicate<MapperInputOutput> predicate;

    ListOperation(String key, Predicate<MapperInputOutput> predicate, Mapper mapper) {
        this.key = Objects.requireNonNull(key);
        this.predicate = Objects.requireNonNull(predicate);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public void accept(Map<String, Object> input, Map<String, Object> output) {
        if (this.predicate.test(MapperInputOutputPair.of(input, output))) {
            output.put(this.key, Collections.singletonList(this.mapper.apply(input)));
        }
    }
}

