/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.MapperMaps;
import com.atlassian.braid.mapper.MapperOperation;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

final class CopyOperation<T, R>
implements MapperOperation {
    private final String sourceKey;
    private final String targetKey;
    private final Supplier<R> defaultValue;
    private final Function<T, R> transform;

    CopyOperation(String sourceKey, String targetKey, Supplier<R> defaultValue, Function<T, R> transform) {
        this.sourceKey = Objects.requireNonNull(sourceKey);
        this.targetKey = Objects.requireNonNull(targetKey);
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.transform = Objects.requireNonNull(transform);
    }

    @Override
    public void accept(Map<String, Object> input, Map<String, Object> output) {
        R value = MapperMaps.get(input, this.sourceKey).map(this.transform).orElseGet(this.defaultValue);
        if (value != null) {
            output.put(this.targetKey, value);
        }
    }
}

