/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.BraidSchemaSource;
import com.atlassian.braid.BraidTypeDefinition;
import com.atlassian.braid.FieldAlias;
import com.atlassian.braid.FieldMutation;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.graphql.language.AliasablePropertyDataFetcher;
import com.atlassian.braid.java.util.BraidCollectors;
import com.atlassian.braid.source.LinkMutation;
import com.atlassian.braid.source.TopLevelFieldMutation;
import graphql.execution.DataFetcherResult;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentBuilder;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BraidSchema {
    private static final Logger log = LoggerFactory.getLogger(BraidSchema.class);
    private final GraphQLSchema schema;
    private final Map<String, BatchLoader> batchLoaders;

    private BraidSchema(GraphQLSchema schema, Map<String, BatchLoader> batchLoaders) {
        this.schema = Objects.requireNonNull(schema);
        this.batchLoaders = Objects.requireNonNull(batchLoaders);
    }

    static BraidSchema from(TypeDefinitionRegistry typeDefinitionRegistry, RuntimeWiring.Builder runtimeWiringBuilder, List<SchemaSource> schemaSources) {
        Map<SchemaNamespace, BraidSchemaSource> dataSourceTypes = BraidSchema.toBraidSchemaSourceMap(schemaSources);
        BraidSchema.findSchemaDefinitionOrCreateOne(typeDefinitionRegistry);
        ObjectTypeDefinition queryObjectTypeDefinition = TypeUtils.findQueryType(typeDefinitionRegistry).orElseGet(() -> TypeUtils.addQueryTypeToSchema(typeDefinitionRegistry, TypeUtils.createDefaultQueryTypeDefinition()));
        ObjectTypeDefinition mutationObjectTypeDefinition = TypeUtils.findMutationType(typeDefinitionRegistry).orElseGet(TypeUtils::createDefaultMutationTypeDefinition);
        Map<String, BatchLoader> batchLoaders = BraidSchema.addDataSources(dataSourceTypes, typeDefinitionRegistry, runtimeWiringBuilder, queryObjectTypeDefinition, mutationObjectTypeDefinition);
        if (!mutationObjectTypeDefinition.getFieldDefinitions().isEmpty()) {
            TypeUtils.addMutationTypeToSchema(typeDefinitionRegistry, mutationObjectTypeDefinition);
        }
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(typeDefinitionRegistry, runtimeWiringBuilder.build());
        return new BraidSchema(graphQLSchema, batchLoaders);
    }

    private static void findSchemaDefinitionOrCreateOne(TypeDefinitionRegistry typeDefinitionRegistry) {
        typeDefinitionRegistry.schemaDefinition().orElseGet(() -> BraidSchema.createDefaultSchemaDefinition(typeDefinitionRegistry));
    }

    private static SchemaDefinition createDefaultSchemaDefinition(TypeDefinitionRegistry typeDefinitionRegistry) {
        SchemaDefinition.Builder builder = SchemaDefinition.newSchemaDefinition();
        typeDefinitionRegistry.getType("Query").ifPresent(__ -> BraidSchema.addOperation(builder, "query", "Query"));
        typeDefinitionRegistry.getType("Mutation").ifPresent(__ -> BraidSchema.addOperation(builder, "mutation", "Mutation"));
        SchemaDefinition schemaDefinition = builder.build();
        typeDefinitionRegistry.add((SDLDefinition)schemaDefinition);
        return schemaDefinition;
    }

    private static void addOperation(SchemaDefinition.Builder schemaDefinition, String queryFieldName, String defaultQueryTypeName) {
        schemaDefinition.operationTypeDefinition(new OperationTypeDefinition(queryFieldName, (Type)new TypeName(defaultQueryTypeName)));
    }

    private static Map<String, BatchLoader> addDataSources(Map<SchemaNamespace, BraidSchemaSource> dataSources, TypeDefinitionRegistry registry, RuntimeWiring.Builder runtimeWiringBuilder, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition) {
        BraidSchema.addAllNonOperationTypes(dataSources, registry, runtimeWiringBuilder);
        List<FieldDataLoaderRegistration> linkedTypesBatchLoaders = BraidSchema.linkTypes(dataSources, queryObjectTypeDefinition, mutationObjectTypeDefinition);
        List<FieldDataLoaderRegistration> queryFieldsBatchLoaders = BraidSchema.addSchemaSourcesTopLevelFieldsToOperation(dataSources, queryObjectTypeDefinition, BraidSchemaSource::getQueryType, BraidSchemaSource::getQueryFieldAlias);
        List<FieldDataLoaderRegistration> mutationFieldsBatchLoaders = BraidSchema.addSchemaSourcesTopLevelFieldsToOperation(dataSources, mutationObjectTypeDefinition, BraidSchemaSource::getMutationType, BraidSchemaSource::getMutationFieldAliases);
        HashMap<String, BatchLoader> loaders = new HashMap<String, BatchLoader>();
        Stream.concat(linkedTypesBatchLoaders.stream(), Stream.concat(queryFieldsBatchLoaders.stream(), mutationFieldsBatchLoaders.stream())).forEach(r -> {
            String key = BraidSchema.getDataLoaderKey(((FieldDataLoaderRegistration)r).type, ((FieldDataLoaderRegistration)r).field);
            BatchLoader linkBatchLoader = (BatchLoader)loaders.get(key);
            if (linkBatchLoader != null) {
                loaders.put(key + "-link", linkBatchLoader);
            }
            runtimeWiringBuilder.type(((FieldDataLoaderRegistration)r).type, wiring -> wiring.dataFetcher(((FieldDataLoaderRegistration)r).field, (DataFetcher)new BraidDataFetcher(key)));
            loaders.put(key, ((FieldDataLoaderRegistration)r).loader);
        });
        return loaders;
    }

    Map<String, BatchLoader> getBatchLoaders() {
        return Collections.unmodifiableMap(this.batchLoaders);
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    private static void addAllNonOperationTypes(Map<SchemaNamespace, BraidSchemaSource> dataSources, TypeDefinitionRegistry registry, RuntimeWiring.Builder runtimeWiringBuilder) {
        Map<String, List<BraidTypeDefinition>> allNonOperationTypeDefinitions = dataSources.values().stream().map(BraidSchemaSource::getNonOperationTypes).flatMap(Collection::stream).collect(Collectors.groupingBy(BraidTypeDefinition::getName));
        List duplicateTypes = allNonOperationTypeDefinitions.values().stream().filter(e -> e.size() > 1).collect(Collectors.toList());
        if (!duplicateTypes.isEmpty()) {
            duplicateTypes.stream().flatMap(Collection::stream).forEach(c -> System.out.printf("Type `%s` from %s is in conflict\n", c.getName(), c.getNamespace()));
            throw new IllegalStateException("Type name conflict exists");
        }
        allNonOperationTypeDefinitions.values().stream().map(types -> (BraidTypeDefinition)types.get(0)).peek(type -> BraidSchema.wireFieldDefinitions(runtimeWiringBuilder, type.getType(), type.getFieldDefinitions())).map(BraidTypeDefinition::getType).forEach(arg_0 -> ((TypeDefinitionRegistry)registry).add(arg_0));
    }

    private static void wireFieldDefinitions(RuntimeWiring.Builder runtimeWiringBuilder, TypeDefinition type, List<FieldDefinition> fieldDefinitions) {
        fieldDefinitions.forEach(fd -> runtimeWiringBuilder.type(type.getName(), wiring -> wiring.dataFetcher(fd.getName(), (DataFetcher)new AliasablePropertyDataFetcher(fd.getName()))));
    }

    private static List<FieldDataLoaderRegistration> addSchemaSourcesTopLevelFieldsToOperation(Map<SchemaNamespace, BraidSchemaSource> dataSources, ObjectTypeDefinition braidOperationType, Function<BraidSchemaSource, Optional<ObjectTypeDefinition>> findOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldAlias>> getFieldAlias) {
        return dataSources.values().stream().map(source -> BraidSchema.addSchemaSourceTopLevelFieldsToOperation(source, braidOperationType, findOperationType, getFieldAlias)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<FieldDataLoaderRegistration> addSchemaSourceTopLevelFieldsToOperation(BraidSchemaSource source, ObjectTypeDefinition braidOperationType, Function<BraidSchemaSource, Optional<ObjectTypeDefinition>> findOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldAlias>> getFieldAlias) {
        return findOperationType.apply(source).map(operationType -> BraidSchema.addSchemaSourceTopLevelFieldsToOperation(source, braidOperationType, operationType, getFieldAlias)).orElse(Collections.emptyList());
    }

    private static List<FieldDataLoaderRegistration> addSchemaSourceTopLevelFieldsToOperation(BraidSchemaSource schemaSource, ObjectTypeDefinition braidOperationType, ObjectTypeDefinition sourceOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldAlias>> getFieldAlias) {
        List<BraidFieldDefinition> fieldDefinitions = BraidSchema.aliasedFieldDefinitions(schemaSource, sourceOperationType, getFieldAlias);
        List braidOperationTypeFieldDefinitions = braidOperationType.getFieldDefinitions();
        fieldDefinitions.forEach(bfd -> braidOperationTypeFieldDefinitions.add(((BraidFieldDefinition)bfd).definition));
        return BraidSchema.wireOperationFields(braidOperationType.getName(), schemaSource, fieldDefinitions);
    }

    private static List<BraidFieldDefinition> aliasedFieldDefinitions(BraidSchemaSource schemaSource, ObjectTypeDefinition sourceOperationType, BiFunction<BraidSchemaSource, String, Optional<FieldAlias>> getFieldAlias) {
        return sourceOperationType.getFieldDefinitions().stream().map(definition -> ((Optional)getFieldAlias.apply(schemaSource, definition.getName())).map(alias -> new BraidFieldDefinition((FieldAlias)alias, (FieldDefinition)definition))).filter(Optional::isPresent).map(Optional::get).map(def -> BraidSchema.aliasedFieldDefinition(schemaSource, def)).collect(Collectors.toList());
    }

    private static BraidFieldDefinition aliasedFieldDefinition(BraidSchemaSource schemaSource, BraidFieldDefinition braidFieldDefinition) {
        FieldDefinition definition = braidFieldDefinition.definition;
        Type aliasedType = schemaSource.aliasType(definition.getType());
        return new BraidFieldDefinition(braidFieldDefinition.alias, FieldDefinition.newFieldDefinition().name(braidFieldDefinition.alias.getBraidName()).type(aliasedType).inputValueDefinitions(schemaSource.aliasInputValueDefinitions(definition.getInputValueDefinitions())).directives(definition.getDirectives()).build());
    }

    private static List<FieldDataLoaderRegistration> wireOperationFields(String typeName, BraidSchemaSource schemaSource, List<BraidFieldDefinition> fieldDefinitions) {
        return fieldDefinitions.stream().map(queryField -> BraidSchema.wireOperationField(typeName, schemaSource, queryField)).collect(Collectors.toList());
    }

    private static FieldDataLoaderRegistration wireOperationField(String typeName, BraidSchemaSource schemaSource, BraidFieldDefinition operationField) {
        BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> batchLoader = BraidSchema.newBatchLoader(schemaSource.getSchemaSource(), new TopLevelFieldMutation(operationField.alias));
        return new FieldDataLoaderRegistration(typeName, operationField.alias.getBraidName(), batchLoader);
    }

    private static List<FieldDataLoaderRegistration> linkTypes(Map<SchemaNamespace, BraidSchemaSource> sources, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition) {
        ArrayList<FieldDataLoaderRegistration> fieldDataLoaderRegistrations = new ArrayList<FieldDataLoaderRegistration>();
        for (BraidSchemaSource source : sources.values()) {
            TypeDefinitionRegistry typeRegistry = source.getTypeRegistry();
            HashMap<String, TypeDefinition> dsTypes = new HashMap<String, TypeDefinition>(typeRegistry.types());
            for (Link link : source.getSchemaSource().getLinks()) {
                BraidSchemaSource targetSource;
                ObjectTypeDefinition typeDefinition = BraidSchema.getObjectTypeDefinition(queryObjectTypeDefinition, mutationObjectTypeDefinition, typeRegistry, dsTypes, source.getLinkBraidSourceType(link));
                BraidSchema.validateSourceFromFieldExists(link, typeDefinition);
                Optional<FieldDefinition> sourceField = typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceField())).findFirst();
                Optional<FieldDefinition> sourceFromField = typeDefinition.getFieldDefinitions().stream().filter(Objects::nonNull).filter(s -> s.getName().equals(link.getSourceFromField())).findAny();
                if (link.isReplaceFromField()) {
                    typeDefinition.getFieldDefinitions().remove(sourceFromField.get());
                }
                if ((targetSource = sources.get(link.getTargetNamespace())) == null) {
                    throw new IllegalArgumentException("Can't find target schema source: " + link.getTargetNamespace());
                }
                if (!targetSource.hasType(link.getTargetType())) {
                    throw new IllegalArgumentException("Can't find target type: " + link.getTargetType());
                }
                TypeName targetType = new TypeName(link.getTargetType());
                if (!sourceField.isPresent()) {
                    if (sourceFromField.isPresent() && BraidSchema.isListType(sourceFromField.get().getType())) {
                        targetType = new ListType((Type)targetType);
                    }
                    FieldDefinition field = new FieldDefinition(link.getSourceField(), (Type)targetType);
                    typeDefinition.getFieldDefinitions().add(field);
                } else if (BraidSchema.isListType(sourceField.get().getType())) {
                    if (sourceField.get().getType() instanceof NonNullType) {
                        sourceField.get().setType((Type)new NonNullType((Type)new ListType((Type)targetType)));
                    } else {
                        sourceField.get().setType((Type)new ListType((Type)targetType));
                    }
                } else {
                    sourceField.get().setType((Type)targetType);
                }
                fieldDataLoaderRegistrations.add(new FieldDataLoaderRegistration(source.getLinkBraidSourceType(link), link.getSourceField(), BraidSchema.newBatchLoader(targetSource.getSchemaSource(), new LinkMutation(link))));
            }
        }
        return fieldDataLoaderRegistrations;
    }

    private static boolean isListType(Type type) {
        return type instanceof ListType || type instanceof NonNullType && ((NonNullType)type).getType() instanceof ListType;
    }

    private static ObjectTypeDefinition getObjectTypeDefinition(ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition, TypeDefinitionRegistry typeRegistry, Map<String, TypeDefinition> dsTypes, String linkSourceType) {
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)dsTypes.get(linkSourceType);
        if (typeDefinition == null && linkSourceType.equals(queryObjectTypeDefinition.getName()) && (typeDefinition = (ObjectTypeDefinition)TypeUtils.findQueryType(typeRegistry).orElse(null)) == null && linkSourceType.equals(mutationObjectTypeDefinition.getName())) {
            typeDefinition = TypeUtils.findMutationType(typeRegistry).orElse(null);
        }
        if (typeDefinition == null) {
            throw new IllegalArgumentException("Can't find source type: " + linkSourceType);
        }
        return typeDefinition;
    }

    private static String getDataLoaderKey(String sourceType, String sourceField) {
        return sourceType + "." + sourceField;
    }

    private static BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> newBatchLoader(SchemaSource schemaSource, FieldMutation fieldMutation) {
        return schemaSource.newBatchLoader(schemaSource, fieldMutation);
    }

    private static void validateSourceFromFieldExists(Link link, ObjectTypeDefinition typeDefinition) {
        typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceFromField())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Can't find source from field: %s", link.getSourceFromField())));
    }

    private static Map<SchemaNamespace, BraidSchemaSource> toBraidSchemaSourceMap(List<SchemaSource> schemaSources) {
        return schemaSources.stream().map(BraidSchemaSource::new).collect(Collectors.groupingBy(BraidSchemaSource::getNamespace, BraidCollectors.singleton()));
    }

    private static class FieldDataLoaderRegistration {
        private final String type;
        private final String field;
        private final BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> loader;

        private FieldDataLoaderRegistration(String type, String field, BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> loader) {
            this.type = type;
            this.field = field;
            this.loader = loader;
        }
    }

    private static final class BraidFieldDefinition {
        private final FieldAlias alias;
        private final FieldDefinition definition;

        private BraidFieldDefinition(FieldAlias alias, FieldDefinition definition) {
            this.alias = alias;
            this.definition = definition;
        }
    }

    private static class BraidDataFetcher
    implements DataFetcher {
        private final String dataLoaderKey;

        private BraidDataFetcher(String dataLoaderKey) {
            this.dataLoaderKey = Objects.requireNonNull(dataLoaderKey);
        }

        public Object get(DataFetchingEnvironment env) {
            DataLoaderRegistry registry = BraidDataFetcher.getDataLoaderRegistry(env);
            CompletableFuture loadedValue = registry.getDataLoader(this.dataLoaderKey).load((Object)env);
            return Optional.ofNullable(registry.getDataLoader(this.dataLoaderKey + "-link")).map(l -> BraidDataFetcher.loadFromLinkLoader(env, loadedValue, (DataLoader<Object, Object>)l)).orElse(loadedValue);
        }

        private static Object loadFromLinkLoader(DataFetchingEnvironment env, Object source, DataLoader<Object, Object> dataLoader) {
            return dataLoader.load((Object)DataFetchingEnvironmentBuilder.newDataFetchingEnvironment((DataFetchingEnvironment)env).source(source).fieldDefinition(env.getFieldDefinition()).build());
        }

        private static DataLoaderRegistry getDataLoaderRegistry(DataFetchingEnvironment env) {
            return BraidDataFetcher.getContext(env).getDataLoaderRegistry();
        }

        private static BraidContext getContext(DataFetchingEnvironment env) {
            return (BraidContext)env.getContext();
        }
    }
}

