/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.Link;
import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class BatchLoaderUtils {
    public static CompletableFuture<List> getTargetIdsFromEnvironment(Link link, DataFetchingEnvironment environment) {
        return BatchLoaderUtils.getFieldValue(environment, link.getSourceFromField()).thenApply(maybeValue -> {
            Object ids = maybeValue.orElse(null);
            if (ids instanceof String || ids instanceof Number) {
                return Collections.singletonList(ids);
            }
            if (ids instanceof List) {
                return (List)ids;
            }
            if (ids == null) {
                if (environment.getFieldType() instanceof GraphQLList) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(null);
            }
            throw new IllegalArgumentException("Unexpected id type: " + ids);
        });
    }

    private static CompletableFuture<Optional<Object>> getFieldValue(DataFetchingEnvironment environment, String fromField) {
        Object source = environment.getSource();
        if (source instanceof CompletableFuture) {
            return ((CompletableFuture)source).thenApply(resolvedSource -> BatchLoaderUtils.getFieldValue(resolvedSource, fromField));
        }
        return CompletableFuture.completedFuture(BatchLoaderUtils.getFieldValue(source, fromField));
    }

    private static Optional<Object> getFieldValue(Object source, String fromField) {
        if (source instanceof Map) {
            return BraidMaps.get((Map)BraidObjects.cast(source), fromField);
        }
        if (source instanceof DataFetcherResult) {
            return BatchLoaderUtils.getFieldValue(((DataFetcherResult)source).getData(), fromField);
        }
        if (source instanceof String || source instanceof Number || source instanceof List) {
            return Optional.of(source);
        }
        throw new IllegalArgumentException("Unexpected actual source type: " + source.getClass());
    }
}

