package com.atlassian.braid.source;

import com.atlassian.braid.FieldAlias;
import com.atlassian.braid.FieldMutation;
import com.atlassian.braid.FieldMutationContext;
import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import static com.atlassian.braid.source.QueryMutationUtils.addFieldToQuery;
import static com.atlassian.braid.source.QueryMutationUtils.cloneField;
import static com.atlassian.braid.source.QueryMutationUtils.getOperationDefinition;
import static java.util.Collections.singletonList;
import static java.util.concurrent.CompletableFuture.completedFuture;


/**
 * A mutation that will fetch the top level field from a remote source, optionally changing the name of the field
 */
public class TopLevelFieldMutation implements FieldMutation {

    private final FieldAlias alias;

    public TopLevelFieldMutation(FieldAlias alias) {
        this.alias = alias;
    }

    @Override
    public CompletableFuture<List<Field>> apply(DataFetchingEnvironment environment, FieldMutationContext context) {
        FieldWithCounter field = cloneField(context, new ArrayList<>(), environment);

        if (alias.getBraidName().equals(field.field.getName()) && !alias.getSourceName().equals(field.field.getName())) {
            field.field.setName(alias.getSourceName());
        }
        addFieldToQuery(context, environment, getOperationDefinition(environment), field);
        return completedFuture(singletonList(field.field));
    }
}
