/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.dataloader;

import com.atlassian.braid.java.util.BraidLists;
import graphql.ExecutionResult;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.impl.CompletableFutureKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazyRecursiveDataLoaderDispatcherInstrumentation
extends SimpleInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(LazyRecursiveDataLoaderDispatcherInstrumentation.class);
    private final DataLoaderRegistry dataLoaderRegistry;

    public LazyRecursiveDataLoaderDispatcherInstrumentation(DataLoaderRegistry dataLoaderRegistry) {
        this.dataLoaderRegistry = Objects.requireNonNull(dataLoaderRegistry);
    }

    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters) {
        return SimpleInstrumentationContext.whenDispatched(__ -> this.dispatch());
    }

    private void dispatch() {
        log.debug("Dispatching all data loaders ({})", (Object)this.dataLoaderRegistry.getKeys());
        DispatchBatchLoaderCalls allDispatched = this.dataLoaderRegistry.getKeys().stream().map(key -> this.dispatchBatchLoader(this.dataLoaderRegistry, (String)key)).reduce(new DispatchBatchLoaderCalls(), (rec$, x$0) -> ((DispatchBatchLoaderCalls)rec$).add(x$0), (x$0, x$1) -> DispatchBatchLoaderCalls.combine((DispatchBatchLoaderCalls)x$0, (DispatchBatchLoaderCalls)x$1));
        if (allDispatched.depth > 0) {
            allDispatched.whenComplete(this::dispatch);
        }
    }

    private DispatchBatchLoaderCall dispatchBatchLoader(DataLoaderRegistry dataLoaderRegistry, String key) {
        DataLoader dataLoader = dataLoaderRegistry.getDataLoader(key);
        int dispatchDepth = dataLoader.dispatchDepth();
        return new DispatchBatchLoaderCall(dispatchDepth, dataLoader.dispatch());
    }

    private static class DispatchBatchLoaderCalls {
        private final int depth;
        private final List<CompletableFuture<List<?>>> futures;

        private DispatchBatchLoaderCalls() {
            this(0);
        }

        private DispatchBatchLoaderCalls(int depth) {
            this.depth = depth;
            this.futures = new ArrayList();
        }

        private DispatchBatchLoaderCalls(int depth, List<CompletableFuture<List<?>>> futures) {
            this.depth = depth;
            this.futures = new ArrayList(futures);
        }

        private DispatchBatchLoaderCalls add(DispatchBatchLoaderCall dbl) {
            return new DispatchBatchLoaderCalls(this.depth + dbl.depth, BraidLists.concat(this.futures, dbl.futures));
        }

        private static DispatchBatchLoaderCalls combine(DispatchBatchLoaderCalls ds1, DispatchBatchLoaderCalls ds2) {
            return new DispatchBatchLoaderCalls(ds1.depth + ds2.depth, BraidLists.concat(ds1.futures, ds2.futures));
        }

        private void whenComplete(Runnable onComplete) {
            CompletableFutureKit.allOf(this.futures).whenComplete((T __, U ___) -> onComplete.run());
        }
    }

    private static class DispatchBatchLoaderCall<V> {
        private final int depth;
        private final CompletableFuture<List<V>> futures;

        private DispatchBatchLoaderCall(int depth, CompletableFuture<List<V>> futures) {
            this.depth = depth;
            this.futures = futures;
        }
    }
}

