/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.java.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collector;

public final class BraidCollectors {
    private BraidCollectors() {
    }

    public static <T> Collector<T, ?, T> singleton() {
        return BraidCollectors.singleton(new SingletonCharacteristics[0]);
    }

    public static <T> Collector<T, ?, T> singleton(SingletonCharacteristics ... characteristics) {
        return BraidCollectors.singleton("Expected only one element", new Object[0], characteristics);
    }

    public static <T> Collector<T, ?, T> singleton(String msg, Object[] args, SingletonCharacteristics ... characteristics) {
        return Collector.of(Arrays.asList(characteristics).contains((Object)SingletonCharacteristics.ALLOW_MULTIPLE_OCCURRENCES) ? HashSet::new : ArrayList::new, Collection::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, collection -> {
            if (collection.size() != 1) {
                throw new IllegalStateException(String.format(msg, args));
            }
            return collection.iterator().next();
        }, new Collector.Characteristics[0]);
    }

    public static enum SingletonCharacteristics {
        ALLOW_MULTIPLE_OCCURRENCES;

    }
}

