/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.GraphQLQueryVisitor;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaSource;
import graphql.introspection.Introspection;
import graphql.language.AbstractNode;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class TrimFieldsSelection {
    public static void trimFieldSelection(final SchemaSource schemaSource, final DataFetchingEnvironment environment, final AbstractNode root) {
        new GraphQLQueryVisitor(){
            private GraphQLOutputType parentType = null;
            private GraphQLOutputType lastFieldType = null;

            @Override
            protected void visitFragmentDefinition(FragmentDefinition node) {
                if (node == root) {
                    this.parentType = this.lastFieldType = TrimFieldsSelection.getFragmentOutputType(environment, () -> ((FragmentDefinition)node).getTypeCondition());
                }
                super.visitFragmentDefinition(node);
            }

            @Override
            protected void visitField(Field node) {
                GraphQLOutputType type;
                if (node == root) {
                    Field field = (Field)root;
                    type = environment.getFieldType();
                    this.parentType = (GraphQLObjectType)environment.getParentType();
                    Optional linkWithDifferentFromField = TrimFieldsSelection.getLinkWithDifferentFromField(schemaSource.getLinks(), this.parentType.getName(), field.getName());
                    if (linkWithDifferentFromField.isPresent() && environment.getSource() == null) {
                        field.setSelectionSet(null);
                        field.setName(((Link)linkWithDifferentFromField.get()).getSourceFromField());
                    }
                } else {
                    TrimFieldsSelection.getLink(schemaSource.getLinks(), this.parentType.getName(), node.getName()).ifPresent(l -> node.setSelectionSet(null));
                    if (TrimFieldsSelection.isTypeNameMetaField(node)) {
                        type = Introspection.TypeNameMetaFieldDef.getType();
                    } else if (this.parentType instanceof GraphQLFieldsContainer) {
                        type = ((GraphQLFieldsContainer)GraphQLFieldsContainer.class.cast(this.parentType)).getFieldDefinition(node.getName()).getType();
                    } else {
                        throw new IllegalStateException(String.format("Could not find definition for field %s, with parent of type: %s", node.getName(), this.parentType));
                    }
                }
                while (type instanceof GraphQLModifiedType) {
                    type = ((GraphQLModifiedType)type).getWrappedType();
                }
                this.lastFieldType = type;
                super.visitField(node);
            }

            @Override
            protected void visitInlineFragment(InlineFragment node) {
                this.parentType = this.lastFieldType = TrimFieldsSelection.getFragmentOutputType(environment, () -> ((InlineFragment)node).getTypeCondition());
                super.visitInlineFragment(node);
            }

            @Override
            protected void visitSelectionSet(SelectionSet node) {
                if (node == null) {
                    return;
                }
                if (!node.getChildren().isEmpty()) {
                    GraphQLOutputType lastParentType = this.parentType;
                    this.parentType = this.lastFieldType;
                    for (Node child : node.getChildren()) {
                        Optional linkWithDifferentFromField;
                        if (child instanceof Field && (linkWithDifferentFromField = TrimFieldsSelection.getLinkWithDifferentFromField(schemaSource.getLinks(), this.parentType.getName(), ((Field)child).getName())).isPresent()) {
                            this.removeSourceFieldIfDifferentThanFromField(node, (Link)linkWithDifferentFromField.get());
                            this.addFromFieldToQueryIfMissing(node, (Link)linkWithDifferentFromField.get());
                        }
                        this.visit(child);
                    }
                    this.parentType = lastParentType;
                }
            }

            private void addFromFieldToQueryIfMissing(SelectionSet node, Link link) {
                Optional<Selection> fromField = node.getSelections().stream().filter(s -> s instanceof Field && ((Field)s).getName().equals(link.getSourceFromField())).findFirst();
                if (!fromField.isPresent()) {
                    node.getSelections().add(new Field(link.getSourceFromField()));
                }
            }

            private void removeSourceFieldIfDifferentThanFromField(SelectionSet node, Link link) {
                node.getSelections().stream().filter(s -> s instanceof Field && ((Field)s).getName().equals(link.getSourceField())).findAny().ifPresent(s -> node.getSelections().remove(s));
            }
        }.visit((Node)root);
    }

    private static boolean isTypeNameMetaField(Field node) {
        return TrimFieldsSelection.isFieldMatchingFieldDefinition(Introspection.TypeNameMetaFieldDef).test(node);
    }

    private static Predicate<Field> isFieldMatchingFieldDefinition(GraphQLFieldDefinition fieldDefinition) {
        return field -> Objects.equals(fieldDefinition.getName(), field.getName());
    }

    private static Optional<Link> getLinkWithDifferentFromField(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName) && l.getSourceField().equals(fieldName) && !l.getSourceFromField().equals(fieldName)).findFirst();
    }

    private static GraphQLOutputType getFragmentOutputType(DataFetchingEnvironment env, Supplier<TypeName> getTypeCondition) {
        GraphQLType type = (GraphQLType)env.getGraphQLSchema().getTypeMap().get(getTypeCondition.get().getName());
        if (!(type instanceof GraphQLOutputType)) {
            throw new IllegalStateException("Unexpected GraphQL type: " + type.getClass());
        }
        return (GraphQLOutputType)GraphQLOutputType.class.cast(type);
    }

    private static Optional<Link> getLink(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName)).filter(l -> l.getSourceFromField().equals(fieldName)).findFirst();
    }
}

