/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.MappingContext;
import com.atlassian.braid.mapper.MapperOperation;
import com.atlassian.braid.mapper.MapperOperations;
import graphql.language.Selection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;

interface SelectionOperation
extends Predicate<Selection>,
BiFunction<MappingContext, Selection, OperationResult> {
    @Override
    default public boolean test(Selection selection) {
        return false;
    }

    @Override
    default public OperationResult apply(MappingContext mappingContext, Selection selection) {
        return SelectionOperation.emptyResult();
    }

    public static OperationResult emptyResult() {
        return SelectionOperation.result(null, null);
    }

    public static OperationResult result(Selection selection) {
        return SelectionOperation.result(selection, null);
    }

    public static OperationResult result(MapperOperation mapper) {
        return SelectionOperation.result(null, mapper);
    }

    public static OperationResult result(Selection selection, MapperOperation mapper) {
        return new OperationResultImpl(selection, mapper);
    }

    public static class OperationResultImpl
    implements OperationResult {
        private final Selection selection;
        private final MapperOperation mapper;

        OperationResultImpl(Selection selection, MapperOperation mapper) {
            this.selection = selection;
            this.mapper = mapper == null ? MapperOperations.noop() : mapper;
        }

        @Override
        public Optional<Selection> getSelection() {
            return Optional.ofNullable(this.selection);
        }

        @Override
        public MapperOperation getMapper() {
            return this.mapper;
        }
    }

    public static interface OperationResult {
        default public Optional<Selection> getSelection() {
            return Optional.empty();
        }

        default public MapperOperation getMapper() {
            return MapperOperations.noop();
        }
    }
}

