/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.yaml;

import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.yaml.snakeyaml.Yaml;

public final class BraidYaml {
    private BraidYaml() {
    }

    public static Map<String, Object> loadAsMap(Supplier<Reader> yaml) {
        return (Map)BraidObjects.cast(BraidYaml.load(yaml, Map.class));
    }

    public static List<Map<String, Object>> loadAsList(Supplier<Reader> yaml) {
        return (List)BraidObjects.cast(BraidYaml.load(yaml, List.class));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T load(Supplier<Reader> yaml, Class<T> type) {
        try (Reader reader = yaml.get();){
            Object object = new Yaml().loadAs(reader, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getKey(Map<String, Object> props, BiFunction<String, Object[], ? extends RuntimeException> exception) {
        return BraidYaml.getStringValue(props, "key", exception);
    }

    public static String getOperationName(Map<String, Object> props, BiFunction<String, Object[], ? extends RuntimeException> exception) {
        return BraidYaml.getStringValue(props, "op", exception);
    }

    public static String getStringValue(Map<String, Object> props, String key, BiFunction<String, Object[], ? extends RuntimeException> exception) {
        return BraidMaps.get(props, key).map(String::valueOf).orElseThrow(() -> (RuntimeException)exception.apply("Could not find attribute (%s) for configuration: %s", new Object[]{key, props}));
    }

    public static String getTargetKey(Map<String, Object> props, String defaultValue) {
        return BraidMaps.get(props, "target").map(String::valueOf).orElse(defaultValue);
    }

    public static Optional<List<Map<String, Object>>> getMapper(Map<String, Object> props) {
        return BraidMaps.get(props, "mapper").map(BraidObjects::cast);
    }

    public static final class OperationNameAndProps {
        private final String operation;
        private final Map<String, Object> properties;

        public OperationNameAndProps(String operation, Map<String, Object> properties) {
            this.operation = operation;
            this.properties = Objects.requireNonNull(properties);
        }

        public Optional<String> getOperation() {
            return Optional.ofNullable(this.operation);
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }
}

