/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.CopyFieldOperation;
import com.atlassian.braid.document.FragmentSpreadOperation;
import com.atlassian.braid.document.InlineFragmentOperation;
import com.atlassian.braid.document.MappingContext;
import com.atlassian.braid.document.PutFieldOperation;
import com.atlassian.braid.document.SelectionOperation;
import com.atlassian.braid.document.SelectionSetMappingResult;
import com.atlassian.braid.document.TypeMapper;
import com.atlassian.braid.java.util.BraidLists;
import com.atlassian.braid.mapper.MapperOperation;
import com.atlassian.braid.mapper.MapperOperations;
import com.atlassian.braid.source.OptionalHelper;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class TypeMapperImpl
implements TypeMapper {
    private static final SelectionOperation FRAGMENT_OPERATION = new FragmentSpreadOperation();
    private static final SelectionOperation INLINE_FRAGMENT_OPERATION = new InlineFragmentOperation();
    private final Predicate<ObjectTypeDefinition> predicate;
    private final List<SelectionOperation> selectionOperations;

    TypeMapperImpl(Predicate<ObjectTypeDefinition> predicate) {
        this(predicate, Collections.emptyList());
    }

    TypeMapperImpl(Predicate<ObjectTypeDefinition> predicate, List<? extends SelectionOperation> selectionOperations) {
        this.predicate = Objects.requireNonNull(predicate);
        this.selectionOperations = new ArrayList<SelectionOperation>((Collection)Objects.requireNonNull(selectionOperations));
    }

    @Override
    public TypeMapper copy(String key, String target) {
        return this.newTypeMapper(new CopyFieldOperation(key, target));
    }

    @Override
    public TypeMapper copyRemaining() {
        return this.newTypeMapper(new CopyFieldOperation());
    }

    @Override
    public TypeMapper put(String key, String value) {
        return this.newTypeMapper(new PutFieldOperation(key, value));
    }

    private TypeMapper newTypeMapper(SelectionOperation fieldOperation) {
        return new TypeMapperImpl(this.predicate, BraidLists.concat(this.selectionOperations, fieldOperation));
    }

    @Override
    public boolean test(ObjectTypeDefinition definition) {
        return this.predicate.test(definition);
    }

    @Override
    public SelectionSetMappingResult apply(MappingContext mappingContext, SelectionSet selectionSet) {
        ArrayList outputSelections = new ArrayList();
        MapperOperation mapper = this.applyOperations(mappingContext, selectionSet.getSelections()).stream().peek(or -> or.getSelection().ifPresent(outputSelections::add)).map(SelectionOperation.OperationResult::getMapper).reduce((o1, o2) -> MapperOperations.composed(o1, o2)).orElse(MapperOperations.noop());
        return new SelectionSetMappingResult(new SelectionSet(outputSelections), mapper);
    }

    private List<SelectionOperation.OperationResult> applyOperations(MappingContext mappingContext, List<Selection> selections) {
        return selections.stream().map(selection -> this.applyOperation(mappingContext, (Selection)selection)).flatMap(OptionalHelper::toStream).collect(Collectors.toList());
    }

    private Optional<SelectionOperation.OperationResult> applyOperation(MappingContext mappingContext, Selection selection) {
        return this.newSelectionOperationsStream().filter(operation -> operation.test(selection)).findFirst().map(operation -> operation.apply(mappingContext, selection));
    }

    private Stream<SelectionOperation> newSelectionOperationsStream() {
        return Stream.concat(this.selectionOperations.stream(), Stream.of(FRAGMENT_OPERATION, INLINE_FRAGMENT_OPERATION));
    }
}

