define('bitbucket/internal/widget/transitions/collapse-transition', ['module', 'exports', 'prop-types', 'react', 'react-transition-group'], function (module, exports, _propTypes, _react, _reactTransitionGroup) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var CollapseTransition = function (_PureComponent) {
        _inherits(CollapseTransition, _PureComponent);

        function CollapseTransition() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, CollapseTransition);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = CollapseTransition.__proto__ || Object.getPrototypeOf(CollapseTransition)).call.apply(_ref, [this].concat(args))), _this), _this.onEnter = function (el) {
                el.style.height = el.clientHeight + 'px';
            }, _this.onEntering = function (el) {
                setTimeout(function () {
                    el.style.height = 0;
                });
            }, _this.onEntered = function (el) {
                el.style.height = 0;
                el.style.display = 'none';
            }, _this.onExit = function (el) {
                el.style.height = 0;
                el.style.display = '';
            }, _this.onExiting = function (el) {
                setTimeout(function () {
                    el.style.height = el.scrollHeight + 'px';
                });
            }, _this.onExited = function (el) {
                el.style.height = 'auto';
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(CollapseTransition, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    isCollapsed = _props.isCollapsed,
                    children = _props.children;

                var duration = CollapseTransition.DURATION;

                var styles = {
                    transition: 'height ' + duration + 'ms ease-in-out',
                    overflow: 'hidden'
                };

                if (!this.wasRendered) {
                    styles.height = isCollapsed ? '0' : 'auto';
                    styles.display = isCollapsed ? 'none' : null;

                    this.wasRendered = true;
                }

                return _react2.default.createElement(
                    _reactTransitionGroup.Transition,
                    {
                        timeout: duration,
                        'in': isCollapsed,
                        unmountOnExit: false,
                        onEnter: this.onEnter,
                        onEntering: this.onEntering,
                        onEntered: this.onEntered,
                        onExit: this.onExit,
                        onExiting: this.onExiting,
                        onExited: this.onExited
                    },
                    children(styles)
                );
            }
        }]);

        return CollapseTransition;
    }(_react.PureComponent);

    CollapseTransition.DURATION = 250;
    CollapseTransition.propTypes = {
        children: _propTypes2.default.func.isRequired,
        isCollapsed: _propTypes2.default.bool
    };
    CollapseTransition.defaultProps = {
        isCollapsed: false
    };
    exports.default = CollapseTransition;
    module.exports = exports['default'];
});