define('bitbucket/internal/widget/tab-nav-link', ['module', 'exports', 'lodash', 'react', 'react-router-dom', 'bitbucket/internal/util/components/react-functional'], function (module, exports, _lodash, _react, _reactRouterDom, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    exports.default = (0, _reactRouterDom.withRouter)((0, _reactFunctional.pure)(
    /**
     * A NavLink that implements that AUI tabs pattern and puts the active class on the parent `li`
     * @param {string} to - The primary path to match on, plus the link to go to on click
     * @param {*} children - The content inside the link
     * @param {object} location - The `location` object from ReactRouter
     * @param {string|string[]} altActivePaths - any other paths that should make this link `active`
     * @returns {ReactElement}
     */
    function (_ref) {
        var to = _ref.to,
            children = _ref.children,
            location = _ref.location,
            _ref$altActivePaths = _ref.altActivePaths,
            altActivePaths = _ref$altActivePaths === undefined ? [] : _ref$altActivePaths;

        var isActive = [to].concat((0, _lodash.castArray)(altActivePaths)).some(function (path) {
            return (0, _reactRouterDom.matchPath)(location.pathname, { path: path, exact: true });
        });

        return _react2.default.createElement(
            'li',
            { className: 'menu-item' + (isActive ? ' active-tab' : '') },
            _react2.default.createElement(
                _reactRouterDom.Link,
                { to: to },
                _react2.default.createElement(
                    'strong',
                    null,
                    children
                )
            )
        );
    }));
    module.exports = exports['default'];
});