define('bitbucket/internal/util/time-i18n-mappings', ['module', 'exports', '@atlassian/aui'], function (module, exports, _aui) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var commentEditedAgeMapping = {
        aMomentAgo: function aMomentAgo() {
            return AJS.I18n.getText('bitbucket.date.format.edited.a.moment.ago');
        },
        oneMinuteAgo: function oneMinuteAgo() {
            return AJS.I18n.getText('bitbucket.date.format.edited.one.minute.ago');
        },
        xMinutesAgo: function xMinutesAgo(param) {
            return AJS.I18n.getText('bitbucket.date.format.edited.x.minutes.ago', param);
        },
        oneHourAgo: function oneHourAgo() {
            return AJS.I18n.getText('bitbucket.date.format.edited.one.hour.ago');
        },
        xHoursAgo: function xHoursAgo(param) {
            return AJS.I18n.getText('bitbucket.date.format.edited.x.hours.ago', param);
        },
        oneDayAgo: function oneDayAgo() {
            return AJS.I18n.getText('bitbucket.date.format.edited.one.day.ago');
        },
        xDaysAgo: function xDaysAgo(param) {
            return AJS.I18n.getText('bitbucket.date.format.edited.x.days.ago', param);
        },
        oneWeekAgo: function oneWeekAgo() {
            return AJS.I18n.getText('bitbucket.date.format.edited.one.week.ago');
        },
        absolute: function absolute(param) {
            return AJS.I18n.getText('bitbucket.date.format.edited.absolute', param);
        }
    };

    exports.default = {
        commentEditedAge: commentEditedAgeMapping
    };
    module.exports = exports['default'];
});