define('bitbucket/internal/util/store/pull-request', ['exports', 'lodash', 'redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/internal/enums', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/rest-actor', './reducers', './selectors', './store'], function (exports, _lodash, _redux, _reselect, _navbuilder, _server, _enums, _entity, _restActor, _reducers, _selectors, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._reducer = exports._actors = exports.selectors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _restActorsForTypes, _requestTypeKeyProps, _combineReducers;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var store = (0, _store2.default)();
    var APP_NAME = _enums.Entity.PULL_REQUEST;

    var requestTypes = {
        REPOSITORY: _enums.Entity.REPOSITORY,
        DASHBOARD: 'DASHBOARD',
        COMMIT: _enums.Entity.COMMIT,
        REPOSITORY_ALL: 'REPOSITORY_ALL'
    };

    /* ACTIONS */
    var LOAD = 'LOAD_PULL_REQUEST';
    var LOAD_SUCCESS = 'LOAD_PULL_REQUEST_SUCCESS';
    var LOAD_FAILURE = 'LOAD_PULL_REQUEST_FAILURE';
    var LOAD_PAGE = 'LOAD_PULL_REQUESTS';
    var LOAD_PAGE_SUCCESS = 'LOAD_PULL_REQUESTS_SUCCESS';
    var LOAD_PAGE_FAILURE = 'LOAD_PULL_REQUESTS_FAILURE';
    var SAVE = 'SAVE_PULL_REQUEST';
    var SAVE_SUCCESS = 'SAVE_PULL_REQUEST_SUCCESS';
    var SAVE_FAILURE = 'SAVE_PULL_REQUEST_FAILURE';
    var SET_ENTITY = 'SET_PULL_REQUEST';

    /* ACTORS */
    var actors = (0, _restActor.restActorsForTypes)((_restActorsForTypes = {}, _defineProperty(_restActorsForTypes, LOAD, function (_ref) {
        var minimalPullRequest = _ref.payload;
        return {
            url: _navbuilder2.default.rest().pullRequest(minimalPullRequest).withParams({
                avatarSize: _enums.AvatarSize.SMALL,
                markup: true
            }).build()
        };
    }), _defineProperty(_restActorsForTypes, SAVE, function (_ref2) {
        var pullRequest = _ref2.payload;
        return {
            url: _navbuilder2.default.rest().pullRequest(pullRequest).build(),
            type: _server.method.PUT,
            data: pullRequest
        };
    }), _defineProperty(_restActorsForTypes, LOAD_PAGE, function (action, state) {
        var requestInfo = getRequestInfo(action)(state);

        if ((0, _lodash.get)(requestInfo, 'loading')) {
            return null;
        }

        if ((0, _lodash.get)(requestInfo, 'pagingMeta.isLastPage')) {
            throw new Error('Cannot request beyond the last page');
        }

        var start = (0, _lodash.get)(requestInfo, 'pagingMeta.nextPageStart', 0);

        var _action$payload = action.payload,
            at = _action$payload.at,
            closedSince = _action$payload.closedSince,
            commit = _action$payload.commit,
            direction = _action$payload.direction,
            _action$payload$limit = _action$payload.limit,
            limit = _action$payload$limit === undefined ? (0, _lodash.get)(requestInfo, 'pagingMeta.limit', _restActor.DEFAULT_PAGE_SIZE) : _action$payload$limit,
            order = _action$payload.order,
            participantStatus = _action$payload.participantStatus,
            repository = _action$payload.repository,
            requestType = _action$payload.requestType,
            role = _action$payload.role,
            roles = _action$payload.roles,
            prState = _action$payload.state;


        var urlBuilder = void 0;

        switch (requestType) {
            case requestTypes.DASHBOARD:
                urlBuilder = _navbuilder2.default.rest().addPathComponents('dashboard', 'pull-requests').withDefinedParams({
                    state: prState,
                    role: role,
                    participantStatus: participantStatus,
                    order: order,
                    closedSince: closedSince
                });
                break;
            case requestTypes.COMMIT:
                urlBuilder = _navbuilder2.default.rest().repository(repository).commits(commit.id).pullRequests();
                break;
            case requestTypes.REPOSITORY_ALL:
                urlBuilder = _navbuilder2.default.rest().repository(repository).allPullRequests().withDefinedParams({
                    direction: direction,
                    at: at,
                    state: prState,
                    order: order
                });

                if (roles && roles.length) {
                    urlBuilder = roles.reduce(function (builder, _ref3, i) {
                        var _builder$withParams;

                        var role = _ref3.role,
                            user = _ref3.user;
                        return builder.withParams((_builder$withParams = {}, _defineProperty(_builder$withParams, 'role.' + (i + 1), role), _defineProperty(_builder$withParams, 'username.' + (i + 1), user), _builder$withParams));
                    }, urlBuilder);
                }
                break;
            default:
                throw new Error('Invalid request type');
        }

        return {
            url: urlBuilder.withParams({
                avatarSize: _enums.AvatarSize.SMALL,
                limit: limit,
                start: start,
                withProperties: true,
                withAttributes: true
            }).build()
        };
    }), _restActorsForTypes));

    store.addActors(actors);

    var requestTypeKeyProps = (_requestTypeKeyProps = {}, _defineProperty(_requestTypeKeyProps, requestTypes.DASHBOARD, ['closedSince', 'order', 'participantStatus', 'role', 'state']), _defineProperty(_requestTypeKeyProps, requestTypes.COMMIT, [['repository', _entity.getRepositoryId], ['commit', _entity.getCommitId]]), _defineProperty(_requestTypeKeyProps, requestTypes.REPOSITORY_ALL, [['repository', _entity.getRepositoryId], 'at', 'direction', 'order', 'state', 'roles']), _requestTypeKeyProps);

    var reducer = (0, _redux.combineReducers)({
        entities: (0, _reducers.entitiesReducer)({
            loadPageSuccess: [LOAD_PAGE_SUCCESS],
            loadSingleSuccess: [LOAD_SUCCESS, SAVE_SUCCESS, SET_ENTITY]
        }, _entity.getPullRequestId),
        requests: (0, _redux.combineReducers)((_combineReducers = {}, _defineProperty(_combineReducers, LOAD, (0, _reducers.singleEntityRequestReducer)({
            start: LOAD,
            end: [LOAD_FAILURE, LOAD_SUCCESS],
            getId: _entity.getPullRequestId
        })), _defineProperty(_combineReducers, SAVE, (0, _reducers.singleEntityRequestReducer)({
            start: [SAVE],
            end: [SAVE_FAILURE, SAVE_SUCCESS],
            getId: _entity.getPullRequestId
        })), _defineProperty(_combineReducers, LOAD_PAGE, (0, _reducers.getRequestPageReducersByType)({
            requestTypeKeyProps: requestTypeKeyProps,
            getId: _entity.getPullRequestId,
            LOAD_PAGE: LOAD_PAGE,
            LOAD_PAGE_FAILURE: LOAD_PAGE_FAILURE,
            LOAD_PAGE_SUCCESS: LOAD_PAGE_SUCCESS
        })), _combineReducers))
    });

    store.addReducers(_defineProperty({}, APP_NAME, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        loadPullRequest: function loadPullRequest(minimalPullRequest) {
            return {
                type: LOAD,
                payload: minimalPullRequest,
                meta: {
                    successType: LOAD_SUCCESS,
                    failureType: LOAD_FAILURE
                }
            };
        },
        savePullRequest: function savePullRequest(pullRequest) {
            return {
                type: SAVE,
                payload: pullRequest,
                meta: {
                    successType: SAVE_SUCCESS,
                    failureType: SAVE_FAILURE
                }
            };
        },
        setPullRequest: function setPullRequest(pullRequest) {
            return {
                type: SET_ENTITY,
                payload: pullRequest
            };
        },
        loadRepositoryPullRequests: function loadRepositoryPullRequests(_ref4) {
            var at = _ref4.at,
                direction = _ref4.direction,
                limit = _ref4.limit,
                order = _ref4.order,
                repository = _ref4.repository,
                roles = _ref4.roles,
                state = _ref4.state;
            return {
                type: LOAD_PAGE,
                payload: {
                    at: at,
                    direction: direction,
                    limit: limit,
                    order: order,
                    repository: repository,
                    roles: roles,
                    state: state,
                    requestType: requestTypes.REPOSITORY_ALL
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        },
        loadCommitPullRequests: function loadCommitPullRequests(_ref5) {
            var commit = _ref5.commit,
                limit = _ref5.limit,
                repository = _ref5.repository;
            return {
                type: LOAD_PAGE,
                payload: {
                    commit: commit,
                    limit: limit,
                    repository: repository,
                    requestType: requestTypes.COMMIT
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        },
        loadDashboardPullRequests: function loadDashboardPullRequests(_ref6) {
            var closedSince = _ref6.closedSince,
                limit = _ref6.limit,
                order = _ref6.order,
                participantStatus = _ref6.participantStatus,
                role = _ref6.role,
                state = _ref6.state;
            return {
                type: LOAD_PAGE,
                payload: {
                    closedSince: closedSince,
                    requestType: requestTypes.DASHBOARD,
                    limit: limit,
                    order: order,
                    participantStatus: participantStatus,
                    role: role,
                    state: state
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        }
    };

    /* SELECTORS */

    var _getSelectorsForApp = (0, _selectors.getSelectorsForApp)({
        appName: APP_NAME,
        getId: _entity.getPullRequestId,
        requestTypeKeyProps: requestTypeKeyProps
    }),
        getEntity = _getSelectorsForApp.getEntity,
        getRequestInfo = _getSelectorsForApp.getRequestInfo,
        getEntitiesForRequest = _getSelectorsForApp.getEntitiesForRequest,
        getLoadingForRequest = _getSelectorsForApp.getLoadingForRequest,
        getAllFetchedForRequest = _getSelectorsForApp.getAllFetchedForRequest;

    var selectors = exports.selectors = {
        getPullRequest: getEntity,
        getPullRequestLoading: function getPullRequestLoading(minimalPullRequestSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([minimalPullRequestSelector], actionCreators.loadPullRequest));
        },
        getPullRequestSaving: function getPullRequestSaving(pullRequestSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([pullRequestSelector], actionCreators.savePullRequest));
        },

        getRepositoryPullRequests: function getRepositoryPullRequests(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryPullRequests));
        },
        getRepositoryPullRequestsLoading: function getRepositoryPullRequestsLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryPullRequests));
        },
        getRepositoryPullRequestsAllFetched: function getRepositoryPullRequestsAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryPullRequests));
        },

        getCommitPullRequests: function getCommitPullRequests(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadCommitPullRequests));
        },
        getCommitPullRequestsLoading: function getCommitPullRequestsLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadCommitPullRequests));
        },
        getCommitPullRequestsAllFetched: function getCommitPullRequestsAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadCommitPullRequests));
        },

        getDashboardPullRequests: function getDashboardPullRequests(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadDashboardPullRequests));
        },
        getDashboardPullRequestsLoading: function getDashboardPullRequestsLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadDashboardPullRequests));
        },
        getDashboardPullRequestsAllFetched: function getDashboardPullRequestsAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadDashboardPullRequests));
        }
    };

    //Exported for testing only
    exports._actors = actors;
    exports._reducer = reducer;
});