define('bitbucket/internal/util/route', ['exports', 'lodash', 'react', 'bitbucket/util/navbuilder', 'bitbucket/internal/util/components/react-functional'], function (exports, _lodash, _react, _navbuilder, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.asRoute = undefined;

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _objectWithoutProperties(obj, keys) {
        var target = {};

        for (var i in obj) {
            if (keys.indexOf(i) >= 0) continue;
            if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
            target[i] = obj[i];
        }

        return target;
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    /**
     * Extract query string params to props object
     *
     * @example
     *
     * getQueryParams('?param1=1&param2=2');
     * // =>  { param1: 1, param2: 2 }
     *
     * @param {string} queryString
     * @returns {object}
     */
    var getQueryParams = function getQueryParams(queryString) {
        return (0, _lodash.fromPairs)((0, _navbuilder.parse)(queryString).queryPairs);
    };

    /**
     * HOC that allows the wrapped component to function as a Route.
     * Allows the component to specify route props (`path`, `exact` etc),
     * rather than have them defined by the parent.
     *
     * Takes care of extracting url values from matched params in the path,
     * queryString params and the hash and hash params.
     *
     * @param {object} routeProps - any props you want set by default on the route, most commonly `path`
     * @returns function(Component)
     */
    var asRoute = function asRoute(routeProps) {
        return function (BaseComponent) {
            var _class, _temp;

            return _temp = _class = function (_PureComponent) {
                _inherits(_class, _PureComponent);

                function _class() {
                    _classCallCheck(this, _class);

                    return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
                }

                _createClass(_class, [{
                    key: 'render',
                    value: function render() {
                        var _props = this.props,
                            computedMatch = _props.computedMatch,
                            location = _props.location,
                            restProps = _objectWithoutProperties(_props, ['computedMatch', 'location']);

                        return _react2.default.createElement(BaseComponent, _extends({}, getQueryParams(location.search), computedMatch.params, {
                            hash: location.hash.substr(1) || undefined,
                            location: location
                        }, restProps));
                    }
                }]);

                return _class;
            }(_react.PureComponent), _class.displayName = 'Route(' + (0, _reactFunctional.getDisplayName)(BaseComponent) + ')', _class.defaultProps = routeProps, _temp;
        };
    };
    exports.asRoute = asRoute;
});