define('bitbucket/internal/util/rest-actor', ['exports', 'lodash', 'bitbucket/util/server'], function (exports, _lodash, _server) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.restActorsForTypes = exports.restActorForType = exports.requestFailure = exports.requestSuccess = exports.NO_FILTER = exports.DEFAULT_PAGE_SIZE = exports.REQUEST_SUCCESS = exports.REQUEST_FAILURE = exports.duplicateStrategy = undefined;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var ABORT_OLD = 'ABORT_OLD';
    var DEFAULT = 'DEFAULT';
    // const QUEUE = 'QUEUE'; //TODO: Not implemented yet
    var DROP_NEW = 'DROP_NEW';

    var duplicateStrategy = exports.duplicateStrategy = {
        ABORT_OLD: ABORT_OLD,
        DEFAULT: DEFAULT,
        // QUEUE,
        DROP_NEW: DROP_NEW
    };

    var REQUEST_FAILURE = exports.REQUEST_FAILURE = 'REQUEST_FAILURE';
    var REQUEST_SUCCESS = exports.REQUEST_SUCCESS = 'REQUEST_SUCCESS';
    var DEFAULT_PAGE_SIZE = exports.DEFAULT_PAGE_SIZE = 25;
    var NO_FILTER = exports.NO_FILTER = '';

    var requestSuccess = exports.requestSuccess = function requestSuccess(action, request, dispatch, successTransform) {
        return function (data) {
            return dispatch({
                type: (0, _lodash.get)(action, 'meta.successType', REQUEST_SUCCESS),
                payload: (0, _lodash.isFunction)(successTransform) ? successTransform(data) : data,
                meta: { originalAction: action, request: request }
            });
        };
    };

    var requestFailure = exports.requestFailure = function requestFailure(action, request, dispatch) {
        return function (xhr, textStatus, err, response) {
            return dispatch({
                type: (0, _lodash.get)(action, 'meta.failureType', REQUEST_FAILURE),
                payload: { textStatus: textStatus, err: err, response: response },
                meta: { originalAction: action, request: request }
            });
        };
    };

    var restActorForType = exports.restActorForType = function restActorForType(type, requestBuilder) {
        var _requests;

        var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
            _ref$duplicateStrateg = _ref.duplicateStrategy,
            duplicateStrategy = _ref$duplicateStrateg === undefined ? DEFAULT : _ref$duplicateStrateg,
            successTransform = _ref.successTransform;

        // The request cache is local to the restActor.
        // Multiple rest actors could therefore make overlapping requests to the same url,
        // without any duplicate request strategy being applied.
        // At the same time making it global would mean potentially conflicting duplicate request strategies
        // This feels like the most logical choice
        var requests = (_requests = {}, _defineProperty(_requests, _server.method.DELETE, {}), _defineProperty(_requests, _server.method.GET, {}), _defineProperty(_requests, _server.method.PATCH, {}), _defineProperty(_requests, _server.method.POST, {}), _defineProperty(_requests, _server.method.PUT, {}), _requests);

        var restActor = function restActor(action, dispatch, state) {
            if (action.type !== type) {
                return;
            }

            var requestConfig = requestBuilder(action, state);

            if (requestConfig === null) {
                return;
            }

            requestConfig.type = requestConfig.type || _server.method.GET;

            var maybeExistingRequest = (0, _lodash.get)(requests, [requestConfig.type, requestConfig.url]);

            if (duplicateStrategy === DROP_NEW && maybeExistingRequest) {
                return;
            }

            if (duplicateStrategy === ABORT_OLD && maybeExistingRequest && maybeExistingRequest.abort) {
                maybeExistingRequest.abort();
            }

            var request = (0, _server.rest)(requestConfig).done(requestSuccess(action, requestConfig, dispatch, successTransform)).fail(requestFailure(action, requestConfig, dispatch));

            if (duplicateStrategy === DROP_NEW || duplicateStrategy === ABORT_OLD) {
                (0, _lodash.set)(requests, [requestConfig.type, requestConfig.url], request.always(function () {
                    if ((0, _lodash.get)(requests, [requestConfig.type, requestConfig.url]) === request) {
                        (0, _lodash.unset)(requests, [requestConfig.type, requestConfig.url]);
                    }
                }));
            }
        };

        //This is just to make debugging a bit easier instead of every rest actor being indistinguishable
        Object.defineProperty(restActor, 'name', { value: 'restActorFor_' + type, writable: false });

        return restActor;
    };

    /**
     * Convenience method for creating a bunch of restActors for the given types
     *
     * @param typeMap - Map of {type: requestBuilder}
     * @returns {array}
     */
    var restActorsForTypes = exports.restActorsForTypes = function restActorsForTypes(typeMap) {
        return (0, _lodash.map)(typeMap, function (requestBuilder, type) {
            return restActorForType(type, requestBuilder);
        });
    };
});