define('bitbucket/internal/util/cache', ['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var Persist = exports.Persist = {
        ONCE: 'ONCE',
        FOREVER: 'FOREVER'
    };

    /**
     * Implements a simple cache based on an object with the ability to configure
     * how long a cache value should persist
     */

    var Cache = function () {
        function Cache() {
            _classCallCheck(this, Cache);

            this.entries = {};
        }

        _createClass(Cache, [{
            key: 'set',
            value: function set(key, value) {
                var persistence = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Persist.FOREVER;

                this.entries[key] = {
                    value: value,
                    persistence: persistence
                };
            }
        }, {
            key: 'get',
            value: function get(key) {
                if (this.has(key)) {
                    var entry = this.entries[key];
                    if (entry.persistence === Persist.ONCE) {
                        delete this.entries[key];
                    }
                    return entry.value;
                }
            }
        }, {
            key: 'has',
            value: function has(key) {
                return this.entries.hasOwnProperty(key);
            }
        }, {
            key: 'clear',
            value: function clear(key) {
                if (!arguments.length) {
                    this.entries = {};
                    return true;
                } else if (this.has(key)) {
                    delete this.entries[key];
                    return true;
                }
                return false;
            }
        }]);

        return Cache;
    }();

    exports.default = Cache;
});