define('bitbucket/internal/route/pull-requests/pull-request-route', ['exports', 'react', 'react-redux', 'react-router-dom', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/internal/next/feature/pull-request/pull-request', 'bitbucket/internal/route/pull-requests/pull-request-commits-route', 'bitbucket/internal/route/pull-requests/pull-request-diff-route', 'bitbucket/internal/route/pull-requests/pull-request-overview-route', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/route', 'bitbucket/internal/util/store/pull-request', 'bitbucket/internal/util/store/repository', 'bitbucket/internal/util/store/selectors'], function (exports, _react, _reactRedux, _reactRouterDom, _reselect, _navbuilder, _pullRequest, _pullRequestCommitsRoute, _pullRequestDiffRoute, _pullRequestOverviewRoute, _entity, _route, _pullRequest3, _repository, _selectors) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.PullRequestRoute = undefined;

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _pullRequest2 = _interopRequireDefault(_pullRequest);

    var _pullRequestCommitsRoute2 = _interopRequireDefault(_pullRequestCommitsRoute);

    var _pullRequestDiffRoute2 = _interopRequireDefault(_pullRequestDiffRoute);

    var _pullRequestOverviewRoute2 = _interopRequireDefault(_pullRequestOverviewRoute);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var PullRequestRoute = exports.PullRequestRoute = function (_PureComponent) {
        _inherits(PullRequestRoute, _PureComponent);

        function PullRequestRoute() {
            _classCallCheck(this, PullRequestRoute);

            return _possibleConstructorReturn(this, (PullRequestRoute.__proto__ || Object.getPrototypeOf(PullRequestRoute)).apply(this, arguments));
        }

        _createClass(PullRequestRoute, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.loadEntitiesIfNecessary();

                if (this.props.unwatch) {
                    console.log('unwatch');
                    //TODO: Do unwatch and redirect to overview. Will need to change the redirect below
                }
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                this.loadEntitiesIfNecessary();
            }
        }, {
            key: 'loadEntitiesIfNecessary',
            value: function loadEntitiesIfNecessary() {
                var _props = this.props,
                    repository = _props.repository,
                    repositoryLoading = _props.repositoryLoading,
                    loadRepository = _props.loadRepository,
                    pullRequest = _props.pullRequest,
                    pullRequestLoading = _props.pullRequestLoading,
                    loadPullRequest = _props.loadPullRequest,
                    projectKey = _props.projectKey,
                    repoSlug = _props.repoSlug,
                    pullRequestId = _props.pullRequestId;


                if (!repository && !repositoryLoading) {
                    loadRepository((0, _entity.buildMinimalRepository)(projectKey, repoSlug));
                }

                if (!pullRequest && !pullRequestLoading) {
                    loadPullRequest((0, _entity.buildMinimalPullRequest)(projectKey, repoSlug, pullRequestId));
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _props2 = this.props,
                    repository = _props2.repository,
                    repositoryLoading = _props2.repositoryLoading,
                    pullRequest = _props2.pullRequest,
                    pullRequestLoading = _props2.pullRequestLoading;


                if (repositoryLoading || pullRequestLoading) {
                    return _react2.default.createElement(
                        'h1',
                        null,
                        'LOADING'
                    );
                }

                if (!repository || !pullRequest) {
                    return null;
                }

                return _react2.default.createElement(
                    _pullRequest2.default,
                    { repository: repository, pullRequest: pullRequest },
                    _react2.default.createElement(
                        _reactRouterDom.Switch,
                        null,
                        _react2.default.createElement(_reactRouterDom.Redirect, {
                            exact: true,
                            path: _navbuilder2.default.pullRequest(pullRequest).buildBase(),
                            to: _navbuilder2.default.pullRequest(pullRequest).overview().build()
                        }),
                        _react2.default.createElement(_pullRequestOverviewRoute2.default, {
                            path: _navbuilder2.default.pullRequest(pullRequest).overview().build(),
                            repository: repository,
                            pullRequest: pullRequest
                        }),
                        _react2.default.createElement(_pullRequestDiffRoute2.default, {
                            path: _navbuilder2.default.pullRequest(pullRequest).diff().build(),
                            repository: repository,
                            pullRequest: pullRequest
                        }),
                        _react2.default.createElement(_pullRequestDiffRoute2.default, {
                            path: decodeURIComponent(_navbuilder2.default.pullRequest(pullRequest).commit(':commitId').build()),
                            repository: repository,
                            pullRequest: pullRequest
                        }),
                        _react2.default.createElement(_pullRequestCommitsRoute2.default, {
                            exact: true,
                            path: _navbuilder2.default.pullRequest(pullRequest).commits().build(),
                            repository: repository,
                            pullRequest: pullRequest
                        })
                    )
                );
            }
        }]);

        return PullRequestRoute;
    }(_react.PureComponent);

    var minimalRepositoryFromProps = (0, _selectors.filteredPropsSelector)(['projectKey', 'repoSlug'], _entity.buildMinimalRepository);

    var minimalPullRequestFromProps = (0, _selectors.filteredPropsSelector)(['projectKey', 'repoSlug', 'pullRequestId'], _entity.buildMinimalPullRequest);

    var mapStateToProps = (0, _reselect.createStructuredSelector)({
        repository: _repository.selectors.getRepository(minimalRepositoryFromProps),
        repositoryLoading: _repository.selectors.getRepositoryLoading(minimalRepositoryFromProps),
        pullRequest: _pullRequest3.selectors.getPullRequest(minimalPullRequestFromProps),
        pullRequestLoading: _pullRequest3.selectors.getPullRequestLoading(minimalPullRequestFromProps)
    });

    var mapDispatchToProps = {
        loadRepository: _repository.actionCreators.loadRepository,
        loadPullRequest: _pullRequest3.actionCreators.loadPullRequest
    };

    exports.default = (0, _route.asRoute)({
        //TODO: Make this work for PRs in personal repos
        path: decodeURIComponent(_navbuilder2.default.project(':projectKey').repo(':repoSlug').pullRequest(':pullRequestId').buildBase())
    })((0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(PullRequestRoute));
});