define('bitbucket/internal/route/pull-requests/pull-request-diff-route', ['module', 'exports', 'react', 'react-redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/internal/next/feature/pull-request/pull-request-changes/pull-request-changes', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/route', 'bitbucket/internal/util/store/commit', 'bitbucket/internal/util/store/selectors'], function (module, exports, _react, _reactRedux, _reselect, _navbuilder, _pullRequestChanges, _entity, _route, _commit, _selectors) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _pullRequestChanges2 = _interopRequireDefault(_pullRequestChanges);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var PullRequestDiffRoute = function (_PureComponent) {
        _inherits(PullRequestDiffRoute, _PureComponent);

        function PullRequestDiffRoute() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, PullRequestDiffRoute);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = PullRequestDiffRoute.__proto__ || Object.getPrototypeOf(PullRequestDiffRoute)).call.apply(_ref, [this].concat(args))), _this), _this.el = _react2.default.createRef(), _this.getStyle = function () {
                var current = _this.el.current;


                if (!current) {
                    //Set initial height to 100vh to allow offsetBottom calculation for < 1 screen initial height
                    //(short tree and short first diff)
                    return { height: '100vh' };
                } else {
                    var boundingRect = current.getBoundingClientRect();

                    var offsetTop = boundingRect.top;
                    var offsetBottom = document.documentElement.scrollHeight - boundingRect.bottom;

                    //Set the height of the diff tab inner to be the height of the page,
                    // minus the offset from the top (app header, PR header, tabs)
                    // and the offset from the bottom, (padding, outer elements)
                    // so that there is no window scrollbar
                    return {
                        height: 'calc(100vh - ' + (offsetTop + offsetBottom) + 'px'
                    };
                }
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(PullRequestDiffRoute, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.loadCommitIfNecessary();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                this.loadCommitIfNecessary();
            }
        }, {
            key: 'loadCommitIfNecessary',
            value: function loadCommitIfNecessary() {
                var _props = this.props,
                    commit = _props.commit,
                    commitId = _props.commitId,
                    commitLoading = _props.commitLoading,
                    loadCommit = _props.loadCommit,
                    repository = _props.repository;


                if (commitId && !commit && !commitLoading) {
                    loadCommit({ repository: repository, commit: (0, _entity.buildMinimalCommit)(commitId) });
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _props2 = this.props,
                    commit = _props2.commit,
                    commitId = _props2.commitId,
                    repository = _props2.repository,
                    pullRequest = _props2.pullRequest,
                    sinceCommitId = _props2.sinceCommitId,
                    filePath = _props2.filePath,
                    fromLine = _props2.fromLine,
                    toLine = _props2.toLine;


                if (commitId && !commit) {
                    return null;
                }

                return _react2.default.createElement(
                    'div',
                    { ref: this.el, style: this.getStyle() },
                    _react2.default.createElement(_pullRequestChanges2.default, {
                        pullRequest: pullRequest,
                        repository: repository,
                        commit: commit,
                        sinceCommitId: sinceCommitId,
                        filePath: filePath,
                        fromLine: fromLine,
                        toLine: toLine
                    })
                );
            }
        }]);

        return PullRequestDiffRoute;
    }(_react.PureComponent);

    var getFilePathFromHash = function getFilePathFromHash(hash) {
        if (!hash) {
            return;
        }

        return hash.split('?')[0] || undefined;
    };

    var getHashParam = function getHashParam(param) {
        return function (hash) {
            return hash && _navbuilder2.default.parse(hash).getQueryParamValue(param);
        };
    };

    var mapStateToProps = (0, _reselect.createStructuredSelector)({
        commit: _commit.selectors.getCommit((0, _selectors.filteredPropsSelector)(['commitId'], _entity.buildMinimalCommit)),
        commitLoading: _commit.selectors.getCommitLoading((0, _selectors.filteredPropsSelector)(['repository', 'commitId'], function (repository, commitId) {
            return {
                repository: repository,
                commit: (0, _entity.buildMinimalCommit)(commitId)
            };
        })),
        sinceCommitId: (0, _selectors.singlePropSelector)('since'),
        filePath: (0, _selectors.filteredPropsSelector)(['hash'], getFilePathFromHash),
        fromLine: (0, _selectors.filteredPropsSelector)(['hash'], getHashParam('F')),
        toLine: (0, _selectors.filteredPropsSelector)(['hash'], getHashParam('T'))
    });

    var mapDispatchToProps = {
        loadCommit: _commit.actionCreators.loadCommit
    };

    exports.default = (0, _route.asRoute)({
        path: decodeURIComponent(_navbuilder2.default.project(':projectKey').repo(':repoSlug').pullRequest(':pullRequestId').diff().build())
    })((0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(PullRequestDiffRoute));
    module.exports = exports['default'];
});