define('bitbucket/internal/page/commits/commits', ['module', 'exports', 'react', 'react-dom', 'bitbucket/util/navbuilder', 'bitbucket/internal/feature/commits/commits-table', 'bitbucket/internal/model/revision-reference', 'bitbucket/internal/util/events', 'bitbucket/internal/util/history', './commits-page-graph'], function (module, exports, _react, _reactDom, _navbuilder, _commitsTable, _revisionReference, _events, _history, _commitsPageGraph) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _commitsTable2 = _interopRequireDefault(_commitsTable);

    var _revisionReference2 = _interopRequireDefault(_revisionReference);

    var _events2 = _interopRequireDefault(_events);

    var _history2 = _interopRequireDefault(_history);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var atRevisionRef;
    var commitsTable;
    var merges;

    function getCommitsUrlBuilder(atRevRef) {
        var builder = _navbuilder2.default.currentRepo().commits();

        atRevRef = atRevRef || atRevisionRef;
        if (!atRevRef.isDefault()) {
            builder = builder.withParams({ until: atRevRef.getId() });
        }

        if (merges) {
            builder = builder.withParams({ merges: merges });
        }

        return builder;
    }

    function bindKeyboardShortcuts() {
        commitsTable.bindKeyboardShortcuts();

        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.keyboard-shortcuts.register-contexts', function (keyboardShortcuts) {
            keyboardShortcuts.enableContext('commits');
        });

        var disableOpenHandler = function disableOpenHandler() {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.disableOpenItemHandler');
        };
        var enableOpenHandler = function enableOpenHandler() {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.enableOpenItemHandler');
        };
        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.branchselector.dialogShown', disableOpenHandler);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.branchselector.dialogHidden', enableOpenHandler);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.layout.branch.actions.dropdownShown', disableOpenHandler);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.layout.branch.actions.dropdownHidden', enableOpenHandler);
    }

    var navigateToCommit = function navigateToCommit(commitId) {
        return location.href = _navbuilder2.default.currentRepo().commit(commitId).build();
    };

    function onReady(atRevisionRefJSON, mergeFilter, _ref) {
        var commitGraphEl = _ref.commitGraphEl;

        atRevisionRef = new _revisionReference2.default(atRevisionRefJSON);
        merges = mergeFilter;
        commitsTable = new _commitsTable2.default(getCommitsUrlBuilder, { focusFirstRow: true });

        if (commitGraphEl) {
            _reactDom2.default.render(_react2.default.createElement(_commitsPageGraph.CommitsPageGraph, {
                headerRowHeight: commitsTable.$table.find('> thead > tr:first').outerHeight(),
                rowHeight: commitsTable.$table.find('> tbody > tr:last').outerHeight(),
                onNodeClick: navigateToCommit
            }), commitGraphEl);
        }

        //Needs to be after the CommitsPageGraph to allow it to set up event listeners
        commitsTable.init();

        _events2.default.on('bitbucket.internal.DO_NOT_USE.layout.branch.revisionRefChanged', function (newAtRevisionRef) {
            if (atRevisionRef.getId() !== newAtRevisionRef.getId()) {
                _history2.default.pushState(newAtRevisionRef.toJSON(), null, getCommitsUrlBuilder(newAtRevisionRef).build());
            }
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.history.changestate', function (e) {
            var state = e.state;
            if (state) {
                atRevisionRef = new _revisionReference2.default(state);
                commitsTable.update();
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.page.commits.revisionRefChanged', null, atRevisionRef);
            }
        });

        bindKeyboardShortcuts();

        _history2.default.initialState(atRevisionRef.toJSON());
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});