define('bitbucket/internal/page/commits/commits-page-graph', ['exports', '@atlassian/aui', 'classnames', 'lodash', 'react', 'bitbucket/util/events', 'bitbucket/internal/bbui/tipsy/tipsy', 'bitbucket/internal/feature/commit-graph/commit-graph', 'bitbucket/internal/util/client-storage', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/widget/icons/icons'], function (exports, _aui, _classnames, _lodash, _react, _events, _tipsy, _commitGraph, _clientStorage, _reactFunctional, _icons) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.CommitsPageGraph = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _events2 = _interopRequireDefault(_events);

    var _tipsy2 = _interopRequireDefault(_tipsy);

    var _clientStorage2 = _interopRequireDefault(_clientStorage);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var clientStorageKey = _clientStorage2.default.buildKey('hide-commit-graph', 'user');

    var getRowCommit = function getRowCommit(row) {
        return JSON.parse(row.getAttribute('data-commit-json'));
    };

    var parseCommits = function parseCommits(tableRows) {
        return tableRows.map(getRowCommit);
    };

    var CommitsPageGraph = exports.CommitsPageGraph = function (_PureComponent) {
        _inherits(CommitsPageGraph, _PureComponent);

        function CommitsPageGraph() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, CommitsPageGraph);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = CommitsPageGraph.__proto__ || Object.getPrototypeOf(CommitsPageGraph)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
                collapsed: _clientStorage2.default.getItem(clientStorageKey) || false,
                commits: [],
                isLastPage: undefined,
                start: undefined
            }, _this.addCommits = function (_ref2) {
                var start = _ref2.start,
                    isLastPage = _ref2.isLastPage,
                    $tableRows = _ref2.values;
                return _this.setState(function (_ref3) {
                    var commits = _ref3.commits;
                    return {
                        commits: commits.concat(parseCommits($tableRows.toArray())),
                        isLastPage: isLastPage,
                        start: start
                    };
                });
            }, _this.focusCommit = function (row) {
                _this.setState({
                    focusedCommitId: getRowCommit(row).id
                });
            }, _this.toggleCollapse = function () {
                return _this.setState(function (_ref4) {
                    var collapsed = _ref4.collapsed;
                    return { collapsed: !collapsed };
                }, function () {
                    return _clientStorage2.default.setItem(clientStorageKey, _this.state.collapsed);
                });
            }, _this.reset = function () {
                return _this.setState({ commits: [] });
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(CommitsPageGraph, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.commitsTable.contentAdded', this.addCommits);
                _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.commitsTable.rowFocused', this.focusCommit);
                _events2.default.on('bitbucket.internal.DO_NOT_USE.history.changestate', this.reset);
                _events2.default.on('bitbucket.internal.DO_NOT_USE.layout.branch.revisionRefChanged', this.reset);
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                _events2.default.off('bitbucket.internal.DO_NOT_USE.widget.commitsTable.contentAdded', this.addCommits);
                _events2.default.off('bitbucket.internal.DO_NOT_USE.widget.commitsTable.rowFocused', this.focusCommit);
                _events2.default.off('bitbucket.internal.DO_NOT_USE.history.changestate', this.reset);
                _events2.default.off('bitbucket.internal.DO_NOT_USE.layout.branch.revisionRefChanged', this.reset);
            }
        }, {
            key: 'render',
            value: function render() {
                var _state = this.state,
                    collapsed = _state.collapsed,
                    commits = _state.commits,
                    focusedCommitId = _state.focusedCommitId,
                    isLastPage = _state.isLastPage,
                    start = _state.start;
                var _props = this.props,
                    headerRowHeight = _props.headerRowHeight,
                    rowHeight = _props.rowHeight,
                    onNodeClick = _props.onNodeClick,
                    onNodeHover = _props.onNodeHover;


                if (!commits.length) {
                    return null;
                }

                //Never collapse the graph if it's only a single page in total
                //(regardless of clientStorage value) and don't show the collapse toggle.
                var isSinglePage = start === 0 && isLastPage === true;

                return _react2.default.createElement(
                    'div',
                    { className: (0, _classnames2.default)('commit-page-graph', { 'single-page': isSinglePage }) },
                    _react2.default.createElement(_commitGraph.CommitGraph, {
                        commits: commits,
                        focusedCommitId: focusedCommitId,
                        offsetY: Math.round(rowHeight / 2) + headerRowHeight,
                        sliceHeight: rowHeight,
                        collapsed: isSinglePage ? false : collapsed,
                        onNodeClick: onNodeClick,
                        onNodeHover: onNodeHover
                    }),
                    !isSinglePage ? _react2.default.createElement(CommitGraphToggle, { collapsed: collapsed, toggleCollapse: this.toggleCollapse }) : null
                );
            }
        }]);

        return CommitsPageGraph;
    }(_react.PureComponent);

    var CommitGraphToggle = (0, _reactFunctional.pure)(function (_ref5) {
        var collapsed = _ref5.collapsed,
            toggleCollapse = _ref5.toggleCollapse;

        var toggleButtonTitle = collapsed ? _aui.I18n.getText('bitbucket.web.repository.commit.graph.show') : _aui.I18n.getText('bitbucket.web.repository.commit.graph.hide');

        return _react2.default.createElement(
            'div',
            { className: 'toggle-commit-graph-container' },
            _react2.default.createElement(
                _tipsy2.default,
                { title: toggleButtonTitle, delay: 300, gravity: 'w' },
                _react2.default.createElement(
                    'button',
                    { className: 'aui-button toggle-commit-graph-button', onClick: toggleCollapse },
                    collapsed ? _react2.default.createElement(_icons.ChevronDoubleRightIcon, null) : _react2.default.createElement(_icons.ChevronDoubleLeftIcon, null)
                )
            )
        );
    });
});